#
# Error management
# ----------------
#
# Just starting this; need to be able to trap sockets being closed better.
# What we want to be able to do is call the "socket_closed" routine, which
# can be provided by the application program to clean up after a closed
# socket connection.  See examples in cmdrc.tcl and openrc.tcl.
#
# Obviously, this needs a bit more work.
#

proc initGkErrorHandling {} {}

proc tkerror {info} {
    case $info in {
        Tcp_PacketReceive*error*reading*file* {
            set f [lindex [split $info] 4]
            filehandler $f
            close $f
            }
        RPC*error*Tcm_ProcessIncomingMessages {
            }
	file*isn*open {
	    catch {socket_closed [lindex $info 1]}
	}
        default {
	    global errorInfo
            error [concat "Unknown error condition" $errorInfo]
            }
    }
}


proc gkProperQuit {} {
    global connections
    foreach i $connections {
	catch {CloseRPC $i}
    }
    after 1 "destroy ."
}
