#ifndef GRID_H
#define GRID_H

//static char* grid_info = "abstract grid";
extern "C" {
#include <tclInt.h>
}

#include <adt/iter.h>

#include <adt/DummyHashEntry.h>

template<class T>
class grid {
public:
grid(int i=1) {
	tbl = &htbl;
	Tcl_InitHashTable(tbl,i);
	}

~grid() {
	Tcl_DeleteHashTable(tbl);
	}

void entry(int* k, T* v) {
	int n;
	Tcl_HashEntry* p;
	do {
		p = Tcl_CreateHashEntry(tbl, (char*) k, &n);
	} while( !n );
	Tcl_SetHashValue(p, (ClientData) v);
	}

T* find(int* k) {
	Tcl_HashEntry* p;
	p = Tcl_FindHashEntry(tbl, (char*) k);
	if (!p)  cerr << "error finding " << k << endl;
	return (T*) Tcl_GetHashValue(p);
	}

T* del(int* k) {
	Tcl_HashEntry* p;
	p = Tcl_FindHashEntry(tbl,(char*) k);
	if (!p)  cerr << "error finding " << k << endl;
	T* v = (T*) Tcl_GetHashValue(p);
	Tcl_DeleteHashEntry( p );
	return v;
	}

inline iter<T> search();

char* stats() {
	return Tcl_HashStats( tbl );
	}
	
T& operator()(int* k) { return *find(k); }

DummyHashEntry<T>& operator[](int* k) {  /// trick to allow assignment
	int n;
	Tcl_HashEntry* p;
	do {
		p = Tcl_CreateHashEntry(tbl,(char*) k, &n);
	} while( !n );
	return * new DummyHashEntry<T>( p );
	}
	
protected:
Tcl_HashTable htbl;
Tcl_HashTable* tbl;
};


template<class T> 
class griditer : public iter<T> {
public:
griditer(Tcl_HashTable* tbl_) : iter<T>(this) {
	tbl = tbl_; sp = &s;
	p = Tcl_FirstHashEntry(tbl,sp);
	}

void dummy(T*) { }

T* operator()() {
	T* v = p ? (T*) Tcl_GetHashValue(p) : 0;
	p = Tcl_NextHashEntry(sp);
	return v;
	}
	
private:
Tcl_HashSearch* sp;
Tcl_HashTable* tbl;
Tcl_HashSearch s;
Tcl_HashEntry* p;
};

template<class T>
inline iter<T> grid<T>::search() { return * new griditer<T>(tbl); }

#endif
