#include <hush/hush.h>
#include <hush/eventnames.h>

char* xeventname(int i) { return xeventnames[i]; }

class widget;
class callback;
class client;

extern char* xeventname(int);

#ifndef HCLONLY
xevent::xevent(union XEvent* p) { last = p; }

int xevent::type() { return last->type; }

char* xevent::name() { return xeventname(last->type); } 
void xevent::trace() {
	cout << name() << "(" << x() << "," << y() << ")" << endl;
	}
union XEvent* xevent::XEvent() { return last; }


class callback* xevent::callback() { return cb; }
class widget* xevent::widget() { return cb->w; }
client* xevent::data() { return cb->data; }
int xevent::no() { return cb->n; }
char* xevent::id() { return cb->it; }

int xevent::x() {
switch (last->type) {
	case ButtonPress:
	case ButtonRelease:
		return last->xbutton.x;
	case MotionNotify:
		return last->xmotion.x;
	case KeyPress:
	case KeyRelease:
		return last->xkey.x;
	default: return -1;
	}
}

int xevent::y() {
switch (last->type) {
	case ButtonPress:
	case ButtonRelease:
		return last->xbutton.y;
	case MotionNotify:
		return last->xmotion.y;
	case KeyPress:
	case KeyRelease:
		return last->xkey.y;
	default: return -1;
	}
}

int xevent::x_root() {
switch (last->type) {
	case ButtonPress:
	case ButtonRelease:
		return last->xbutton.x_root;
	case MotionNotify:
		return last->xmotion.x_root;
	case KeyPress:
	case KeyRelease:
		return last->xkey.x_root;
	default: return -1;
	}
}

int xevent::y_root() {
switch (last->type) {
	case ButtonPress:
	case ButtonRelease:
		return last->xbutton.y_root;
	case MotionNotify:
		return last->xmotion.y_root;
	case KeyPress:
	case KeyRelease:
		return last->xkey.y_root;
	default: return -1;
	}
}

int xevent::button(int i) {
int n = buttno();
if ( ( type() == ButtonPress ) && ( i==0?1:n==i ) )  return n;
else return 0;
//return (( type() == ButtonPress ) && ( i==0?1:buttno()==i ) ) ? buttno : 0; 
}

int xevent::buttonup(int i) {
int n = buttno();
if ( ( type() == ButtonRelease ) && ( i==0?1:n==i ) )  return n;
else return 0;
//return (( type() == ButtonRelease ) && ( i==0?1:buttno()==i ) ) ? buttno : 0;
}

int xevent::keycode() {
if (keyevent()) return last->xkey.keycode; else return -1; 
}

int xevent::buttonevent(int i) {
return buttevent() && ( i==0?1:buttno()==i ); 
}

int xevent::keyevent() {
int type = last->type; return (type==KeyPress) || (type==KeyRelease); 
}

int xevent::motion() { return (last->type == MotionNotify); }

// private:

int xevent::buttevent() {
return ((type()==ButtonPress) || (type()==ButtonRelease));
}

int xevent::buttno() {
if (buttevent()) return last->xbutton.button; else return -1;
}

#endif


/// for discrete event simulation 

void event::dependent(event* e) {
	if (!contains(e)) insert(e);
	else if (0) {
	  cerr << "*** circular dependency by linking ";
	  cerr << e->type() << " to " << this->type() << endl;
	  }
	}

void event::insert(event* e) {
	if (!next) next = new event(e);
	else next->insert(e);
	}

void event::update() {
	if (secondary) {
	    if (ev) ev->operator()();
	    }
	if (next) next->update();
	}

int event::contains(event* e) {
	if (this == e) return 1;
	if (secondary) {
		if (ev == e) return 1;
		else if (ev = this) return 1;
		else if (next) return next->contains(e);
	}
	return 0;
	}

