#!/fs/world/tcl/bin/img_wish -f

proc load_file_lb { path args } {
#    ------------       
#
#  path is the pathname of a listbox widget
#  args are patterns of filenames to be included in the listbox
#
	global $path-pwd
	set $path-pwd [pwd]
	$path delete 0 end
	if [string match "-*" [lindex $args 0]] {
	   set flags [lindex $args 0]
	   set args [lreplace $args 0 0]
	} else {
	   set flags ""
	}
	if {$args==""} return
	set filelist [eval "glob -nocomplain $args"]
	if {$filelist==""} return
	foreach f [eval "exec ls $flags $filelist"] {
	   $path insert end $f
	}
}

proc file_lb_sel { path y cmd args } {
#    -----------
#
#  Callback routine used by a file_lb. 'path' is the path of the widget,
#  'y' is the y coord of where the mouse was double-clicked; 'cmd' is
#  the command to be executed and 'args' are patterns of files to be
#  displayed in the listbox
#
	set f [$path get [$path nearest $y]]
	set trimf [string trimright $f /]
	if [file isdir $trimf] {
	    cd $trimf
	    eval "load_file_lb $path $args"
	} else {
	    eval "$cmd $f"
	}
}

proc create_file_lb { path cmd args } {
#
#  creates a listbox of filenames under 'path'. The filenames
#  included in the listbox must either be directories or match one
#  of the patterns in args. double-clicking a directory cd's the application
#  into that directory (also, a global variable called $path-pwd is
#  set to the present working directory).
#  double-clicking a file invokes command 'cmd' with the filename as 
#  its argument.
#
	pack [frame $path-f] -expand yes -fill both
	listbox $path -yscroll "$path-sb set" -exportselection 0
	scrollbar $path-sb -command "$path yview"	
	pack $path -expand yes -fill both -side left -in $path-f
	pack $path-sb -expand n -fill y -side right -in $path-f
	eval "load_file_lb $path $args"
	tk_listboxSingleSelect $path
	bind $path <Double-1> "file_lb_sel $path %y $cmd $args"
}


proc show_image { filename } {
#    ----------
#
#  'filename' designates a file containing an image in gif, jpg or 
#  ppm format. This proc pops a window to show it
#
	global gamma imgscale currentfile	
	update

	if ![file exists $filename] {
	   set filelist [glob -nocomplain $filename?]
	   if [llength $filename]>0 { 
	      exec mv [lindex $filelist 0] $filename	      
	   } else {
	      tk_dialog .errmsg Error \
		"$filename can't be opened" error 0 Rats!
	      return
	   }
        }

	set currentfile $filename

	if ![winfo exists .f.img] {
	    toplevel .f
	    raster .f.img 
	    set path .f.img
	    bind $path <Button-3> "wm iconify .f"
	    bind $path <Button-2> { .opt.menu.gamma post %X %Y }
	    bind $path <Button-1> { .file.menu.del post %X %Y }
	}

	.f.img config -width 10 -height 10

	if {[string match "*gif*" $filename] ||
	    [string match "*GIF*" $filename]} {
	    set filename "|giftoppm $filename"
	} elseif {[string match "*jpg" $filename] ||
		  [string match "*JPG*" $filename]} {
	    set filename "|djpeg -colors 256 $filename"
	} elseif {[string match "*PCX*" $filename] ||
		  [string match "*pcx*" $filename]} {
	    set filename "|pcxtoppm $filename"
	} elseif {[string match "*.icon" $filename]||
		  [string match "*.pr" $filename]||
		  [string match "*.image" $filename]} {
	    set filename "|icontopbm $filename"
	}

	if {$gamma!=1} { 
	   if {[string index $filename 0]!="|"} {
	      set filename "|pnmgamma $gamma $filename"
	   } else {
	      append filename " | pnmgamma $gamma" 
	   }
	}

	if {$imgscale!=1} {
	   if {[string index $filename 0]!="|"} {
	      set filename "|pnmscale $imgscale $filename"
	   } else {
	      append filename " | pnmscale $imgscale" 
	   }
	}		

	catch ".f.img image delete img"
	set result [.f.img image load img $filename]

#	if {$result!=""} {
#	   tk_dialog .errmsg Error \
#		"warning: $filename could not be read properly: $result"\
#		warning 0 Rats!
#	}	

	wm title .f $currentfile
	wm iconname .f $currentfile
	set size [.f.img image info img]
	.f.img config -width [lindex $size 0] -height [lindex $size 1]
	.f.img image put img 0 0
	pack .f.img
}

proc show_current { path } {
#    ------------
#
#  Show the image in the currently selected file in filebox 'path'
#
	update idletasks
	set idx [$path curselection]
	if {$idx==""} { return 0 }
	set name [$path get $idx]
	if [file isfile $name] { 
	    show_image $name
	}
}

proc select_idx { path idx } {
#    ----------
#
#  Selects the given element (idx) from listbox 'path' and makes
#  sure that the element is visible within the window
#
	set first [$path nearest 0]
	set last [$path nearest [winfo height $path]]
	if $idx<$first||$idx>$last {
	   $path yview $idx
	}
	$path select from $idx
}

proc next_file { path } {
#    ---------
#
#  Selects the next file in path
#
	set idx [$path curselection]
	if {$idx==""} { return 0 }
	incr idx
	if $idx>=[$path size] { return 0 }
	select_idx $path $idx
	return 1
}

proc prev_file { path } {
#    ---------
#
#  Selects the next file in path
#
	set idx [$path curselection]
	if {$idx==""} { return 0 }
	incr idx -1
	if $idx<0 { return 0 }
	select_idx $path $idx
	return 1
}

proc del_file { path } {
#    --------
#
#  Deletes the file from the list and from the directory
#	
	set idx [$path curselection]
	if {$idx==""} { return "" }
	set name [$path get $idx]
	if ![next_file $path] { prev_file $path }
	$path delete $idx
	return $name
}

proc reloadimage {} {
	global currentfile
	if {$currentfile!=""} {show_image $currentfile}
}

proc reloadfilelist {} {
	global sortorder
	load_file_lb .lb $sortorder *.gif* *.GIF* *.jpg* *.JPG* *.ppm *.pcx *.icon *.pr *.image
}

proc reloadcdmenu {} {
	global lastdir
	set dir [pwd]
	if [info exists lastdir] {
	   if {$dir==$lastdir} return
	}
	set lastdir $dir
	.file.menu.cd delete 0 last
	foreach f [glob -nocomplain *] {
	    if [file isdir $f] { lappend dirlist $f }
	}
	while {$dir!="/"} {
	    set dir [file dirname $dir]
	    if [file isdir $dir] { lappend dirlist $dir }
	}
	foreach d $dirlist {
	    .file.menu.cd add command -label $d \
		-command "cd $d ; reloadfilelist"
	}
}

proc setaccelerators { path } {
	bind $path <Control-n> { .next invoke }
	bind $path <space> { .next invoke }
	bind $path <Control-p> { .prev invoke }
	bind $path <Control-g> { .opt.menu.gamma post %X %Y }
	bind $path <Control-s> { .opt.menu.scale post %X %Y }
	bind $path <Control-d> { .file.menu.del post %X %Y }
	bind $path <Control-o> { .file.menu.sort post %X %Y }
	bind $path <Control-c> { reloadcdmenu; .file.menu.cd post %X %Y }
	bind $path <Control-q> { exit }
	bind $path <q> { exit }
}

proc setallchildren { path } {
	set wlist [winfo children $path] 
	setaccelerators $path
	foreach w $wlist {
	   setallchildren $w
	}
}

proc autounpost { menu } {
	bind $menu <Leave> "$menu unpost"
}
		
set currentfile ""
set gamma 1
set imgscale 1
set autoload 1
set sortorder "-dt"

wm maxsize . 1152 900

pack [frame .cmdbox] -fill x 
menubutton .file -text File -menu .file.menu -relief raised
button .next -text Next -command {if [next_file .lb] {show_current .lb}}
button .prev -text Prev -command {if [prev_file .lb] {show_current .lb}}
menubutton .opt -text Options -menu .opt.menu -relief raised
pack .file .next .prev .opt -fill x -expand yes -side left -in .cmdbox

menu .file.menu
.file.menu add cascade -label Delete -menu .file.menu.del
.file.menu add cascade -label Sort -menu .file.menu.sort
.file.menu add cascade -label Dir -menu .file.menu.cd -command reloadcdmenu
.file.menu add command -label Quit -command exit

menu .file.menu.del
autounpost .file.menu.del
.file.menu.del add command -label "Entry Only" -command {
    del_file .lb
    if $autoload { show_current .lb }
}
.file.menu.del add command -label "File & Entry" -command {
    exec rm -f [del_file .lb]
    if $autoload { show_current .lb }
}

menu .file.menu.sort
autounpost .file.menu.sort 
foreach s {{Name "-d"} {LastAccess "-dtu"} {LastModified "-dt"}} {
   .file.menu.sort add radiobutton -label [lindex $s 0] -variable sortorder \
	-value [lindex $s 1] -command reloadfilelist
}

menu .file.menu.cd
autounpost .file.menu.cd 
	
menu .opt.menu
.opt.menu add checkbutton -label "Auto Load" \
    -variable autoload -onvalue 1 -offvalue 0
.opt.menu add cascade -label Gamma -menu .opt.menu.gamma
.opt.menu add cascade -label Scale -menu .opt.menu.scale 

menu .opt.menu.gamma
autounpost .opt.menu.gamma
foreach g {0.5 0.75 1 1.5 1.75 2 2.5 3 3.5 4 5} {
   .opt.menu.gamma add radiobutton -label $g -variable gamma -value $g \
       -command { if $autoload reloadimage }
}

menu .opt.menu.scale 
autounpost .opt.menu.scale 
foreach s {0.25 0.5 0.75 1 1.5 2 4} {
   .opt.menu.scale add radiobutton -label $s -variable imgscale -value $s \
       -command { if $autoload reloadimage }
} 

pack [frame .dirbox -relief groove -bd 2]  -fill x
pack [label .pwd -textvar .lb-pwd] -fill x -side left -in .dirbox

create_file_lb .lb "show_image" "*.icon" "*.gif*" "*.GIF*" "*.JPG*" "*.jpg*" \
    "*.ppm*" "*.pcx" *.icon *.pr *.image

if {$argc==1&&[file isdir [lindex $argv 0]]} {
	cd [lindex $argv 0]
	reloadfilelist
} elseif {$argc>0} {
	eval "load_file_lb .lb $sortorder $argv"
} else {
	reloadfilelist
}

setallchildren .
focus .
focus default .

	
	