#---------------------------------------------------------------------------
#
#	Create a listbox with an associated scrollbar
#
#---------------------------------------------------------------------------

defwidget Listbox Window {{delay 100}}

defmethod Listbox new {name args} {
  global font color

  args	action double {textfont text} title {titlefont bold} layout init \
	yscroll

  Frame new ${name} -layout $layout
  defsuper $name Listbox

  Label newnonempty $name.title -text $title -textfont $titlefont

  if { $yscroll == {} } {
    set yscrollcmd [list $name.scrolly! set]
  } {
    set yscrollcmd $yscroll
  }

  set list $name.list
  listbox $list -font [Font slot $textfont] -relief sunken \
	-background [Color slot bg] \
	-selectforeground [Color slot fg,active] \
	-selectbackground [Color slot bg,active] \
	-xscroll "$name.scrollx! set" \
	-yscroll $yscrollcmd
  Listbox instantiate $list {}

  if { $yscroll == {} } {
    Scrollbar new $name.scrolly -layout {right filly} \
	-dir vertical -action [list $list! yview]
  }
  Scrollbar new $name.scrollx -layout {bottom fillx} \
	-dir horizontal -action [list $list! xview]

  if { $init != {} } {
    eval [concat [list $list! insert end] $init]
  }

  $list layout {top expand fill}

  bind $list <ButtonRelease-1> [list %W _select %y $action]
  if { $double != {} } then {
    bind $list <Double-Button-1> [list %W _select %y $double]
  }

  return $name
}

defmethod Listbox _select_start {y} {

  $self! select from [$self! nearest $y]
  $self grab
}

defmethod Listbox _select {y action} {

  $self ungrab
  set isel [$self! nearest $y]
  $self! select clear
  $self! select from ${isel}
  set sel [$self! get [lindex $isel 0]]
  if { $action != {} && $isel >= 0 } {
    eval [concat $action [list $self $isel $sel]]
  }
}

defmethod Listbox get {} {

  set size [$self.list! size]
  set list {}
  for {set i 0} {$i < $size} {incr i} {
    lappend list [$self.list! get $i]
  }
  return $list
}

defmethod Listbox set {values} {

  $self.list! delete 0 end
  eval [concat [list $self.list! insert end] $values]
  $self.list! select clear
}

#---------------------------------------------------------------------------

Window addDemo Listbox

defmethod Listbox demo {} {

  set t [Toplevel new * -title "New Toplevel" -info true -resizable true]
  Listbox new *$t \
	-init {John Mary Fred Susan Frank Tom Jill Jack Sarah Jenny Mark} \
	-layout top
  Button new *$t -layout {padx 20 pady 20 bottom} \
	-textfont largebold -text "Dismiss" \
	-action [list $t Dismiss]
}

#---------------------------------------------------------------------------

bind Listbox <1> [list %W _select_start %y]
bind Listbox <2> [list %W! scan mark %x %y]
bind Listbox <B1-Motion> [list %W _select_start %y]
bind Listbox <B2-Motion> [list %W! scan dragto %x %y]
bind Listbox <Shift-1> [list %W _select_start %y]
bind Listbox <Shift-B1-Motion> [list %W _select_start %y]

#---------------------------------------------------------------------------
#
#	History windows
#
#	new(history) root -action
#	history_add root what
#

defwidget History

defmethod History new {name args} {

  args	action layout

  Listbox new $name -layout $layout -action [list $name action $action]
  defsuper $name History

  return $name
}

defmethod History action {action list isel sel} {

  if { $action != {} } {
    eval [concat ${action} [list ${sel}]]
  }
}

defmethod History set {string} {

  if { [$self slot last] != $string } {
    $name.list insert end $string
    $self slot last $string
  }
  return $string
}

defmethod History get {} {

  $self slot last
}
