
defwidget Text

defmethod Text new {name args} {

  args	{textfont text} {relief sunken} {width 40} {height 3} {wrap char} \
	layout {state disabled} text yscroll action max filter

  text $name \
	-font [Font slot $textfont] \
	-relief $relief -setgrid false \
	-borderwidth 2 -width $width -height $height \
	-padx 5 -pady 5 -wrap $wrap \
	-background [Color slot bg] \
	-foreground [Color slot fg] \
	-selectforeground [Color slot fg,active] \
	-selectbackground [Color slot bg,active] \
	-yscrollcommand $yscroll

  $name insert 0.0 $text
  $name mark set insert 0.0
  $name mark set anchor insert
  $name configure -state $state

  Text instantiate $name $layout [list \
	[list max $max] \
	[list action $action] \
	[list filter $filter] \
	]
}

defmethod Text get {} {
  $self! get 0.0 end
}

defmethod Text set {text} {

  set max [$self slot max]
  if { $max != {} && [string length $text] > $max } {
    set text [string range $text 0 [expr $max-1]]
  }

  set state [lindex [$self! configure -state] 4]
  $self! configure -state normal
  $self! delete 0.0 end
  $self! insert 0.0 $text
  $self! mark set insert 0.0
  $self! mark set anchor insert
  $self! configure -state $state

  return
}

defmethod Text keypress {code} {

  if { $code == "" } {
    return
  }

  set max [$self slot max]
  set filter [$self slot filter]

  if { $filter != {} } {
    set code [eval [concat $filter [list $code]]]
    if { $code == "" } {
      return
    }
  }

  if { $code != "" } {
    if { $max == "" || [string length [$self! get 0.0 end]] < $max } {
      $self! insert insert $code
      $self! yview -pickplace insert
    }
  }
}

defmethod Text see_caret {} {
  $self! yview -pickplace insert
}

defmethod Text backspace {} {
  $self! delete insert-1c insert
  $self! yview -pickplace insert
}

defmethod Text delete {} {
  catch {$self! delete sel.first sel.last}
}

defmethod Text erase {} {
  catch	{$self! delete 0.0 end}
}

defmethod Text action {} {

  set action [$self slot action]
  if { $action == {} } then {
    $self! insert insert "\n"
    $self! yview -pickplace insert
  } {
    uplevel #0 [concat $action [list [$self! get 0.0 end]]]
  }
}

defmethod Text position {where} {
  $self! mark set insert $where
  $self! yview -pickplace insert
}

defmethod Text insert {what} {
  $self! insert insert $what
  $self! yview -pickplace insert
}

#---------------------------------------------------------------------------

bind Text <Any-KeyPress> [list %W keypress %A]

bind Text <BackSpace> [list %W backspace]
bind Text <Delete> [list %W backspace]
bind Text <Control-h> [list %W backspace]
bind Text <Control-d> [list %W delete]
bind Text <Control-u> [list %W erase]

bind Text <Control-a> [list %W position 0.0]
bind Text <Control-e> [list %W position end]

bind Text <Key-Return> [list %W action]

bind Text <1> {
  set tk_priv(selectMode) char
  %W! mark set insert @%x,%y
  %W! mark set anchor insert
  if {[lindex [%W! config -state] 4] == "normal"} {
    focus %W
  }
}

bind Text <Double-1> {
  set tk_priv(selectMode) word
  %W! mark set insert "@%x,%y wordstart"
  _text(select) %W insert
}
bind Text <Triple-1> {
  set tk_priv(selectMode) line
  %W! mark set insert "@%x,%y linestart"
  _text(select) %W insert
}

bind Text <B1-Motion> {
  _text(select) %W @%x,%y
}

bind Text <Shift-1> {
  _text(reanchor) %W @%x,%y
  _text(select) %W @%x,%y
}

bind Text <Shift-B1-Motion> {
  _text(select) %W @%x,%y
}

bind Text <2> {
  %W! scan mark %y
}

bind Text <B2-Motion> {
  %W! scan dragto %y
}

proc _text(select) {w index} {
  global tk_priv

  case $tk_priv(selectMode) {
    char {
      if [$w! compare $index < anchor] {
	set first $index
	set last anchor
      } else {
	set first anchor
	set last [$w! index $index+1c]
      }
    }
    word {
      if [$w! compare $index < anchor] {
        set first [$w! index "$index wordstart"]
        set last [$w! index "anchor wordend"]
      } else {
        set first [$w! index "anchor wordstart"]
        set last [$w! index "$index wordend"]
      }
    }
    line {
      if [$w! compare $index < anchor] {
        set first [$w! index "$index linestart"]
        set last [$w! index "anchor lineend + 1c"]
      } else {
        set first [$w! index "anchor linestart"]
        set last [$w! index "$index lineend + 1c"]
      }
    }
  }
  $w! tag remove sel 0.0 $first
  $w! tag add sel $first $last
  $w! tag remove sel $last end
}

proc _text(reanchor) {w index} {
    global tk_priv
    if {[$w! tag ranges sel] == ""} {
        set tk_priv(selectMode) char
        $w! mark set anchor $index
        return
    }
    if [_text(closer) $w $index sel.first sel.last] {
        if {$tk_priv(selectMode) == "char"} {
            $w! mark set anchor sel.last
        } else {
            $w! mark set anchor sel.last-1c
        }
    } else {
        $w! mark set anchor sel.first
    }
}

proc _text(closer) {w a b c} {
    set a [$w! index $a]
    set b [$w! index $b]
    set c [$w! index $c]
    if [$w! compare $a <= $b] {
        return 1
    }
    if [$w! compare $a >= $c] {
        return 0
    }
    scan $a "%d.%d" lineA chA
    scan $b "%d.%d" lineB chB
    scan $c "%d.%d" lineC chC
    if {$chC == 0} {
        incr lineC -1
        set chC [string length [$w! get $lineC.0 $lineC.end]]
    }
    if {$lineB != $lineC} {
        return [expr {($lineA-$lineB) < ($lineC-$lineA)}]
    }
    return [expr {($chA-$chB) < ($chC-$chA)}]
}
