#
#	Created by Juergen Wagner, Apr 1993, FhG-IAO Stuttgart.
#
#	This has been derived from a piece of software posted by
#	Sam Shen (sls@aero.org).
#
#---------------------------------------------------------------------------

defwidget Debugger

defmethod Debugger new {name args} {

  args	{layout center}

  Toplevel new $name -info true
  defsuper $name Debugger

  Buttonpanel new $name.buttons \
	-buttons {Update Send_Value Command Windows} \
	-layout {right filly} \
	-handler $name \
	-actions {Update Send_Value Command Windows Dismiss}

  Label new $name.status \
	-width 60 \
	-layout {bottom fillx expand}

  Inputline new $name.cmd \
	-edittext true -input any \
	-width 60 -textfont small \
	-layout {bottom expand fillx} \
	-label "Command:" \
	-action [list $name Command]

  Text new $name.value \
	-textfont fixed \
	-layout {bottom expand fill} \
	-height 16 -width 40 \
	-state normal

  Listbox new $name.interps -textfont small \
	-layout {left fill expand} \
	-title "Interpreters" \
	-action [list $name _update]

  Listbox new $name.procs -textfont small \
	-layout {left fill expand} \
	-title "Procedures" \
	-action [list $name _select]

  Listbox new $name.globals -textfont small \
	-layout {left fill expand} \
	-title "Global Variables" \
	-action [list $name _select]

  $name Update {}
  $name.status set "Ready..."

  $name layout $layout
}

#---------------------------------------------------------------------------

defmethod Debugger Update {action} {

  $self.interps set [winfo interps]
  $self.procs set {}
  $self.globals set {}
  $self slot _interp {}
}

defmethod Debugger _update {list targetindex target} {

  if {[catch {send $target "info tclversion"} result] != 0} {
    $self.status set $result
    catch [list exec delinterp $target]
    $self Update {}
    return
  }
  $self slot _interp $target

  set procs [send $target info procs]
  set globals [send $target info globals]
  $self.procs set [lsort $procs]
  $self.globals set [lsort $globals]
  $self.status set "Debugging target set to interpreter $target."

  return
}

#---------------------------------------------------------------------------

defmethod Debugger _select {list thingindex thing} {

  set interp [$self slot _interp]

  if { $list == "$self.procs.list" } {
    set stuff [list proc $thing \
		    [send $interp info args $thing] \
		    [send $interp info body $thing]]
  } elseif { [catch {send $interp [list set $thing]} result] == 0} {
    set stuff [list set $thing $result]
  } {
    set stuff ""
    foreach item [lsort [send $interp [list array names $thing]]] {
      set form [list set [format %s(%s) $thing $item]]
      append stuff $form " " [list [send $interp $form]] "\n"
    }
  }
  $self.value set $stuff
  return
}

#---------------------------------------------------------------------------

defmethod Debugger Send_Value {action} {

  set form [$self.value get]
  if {[catch {send [$self slot _interp] $form} stuff] } {
    $self.value set $stuff
  }
}

defmethod Debugger Command {action} {

  if { $action != {} } {
    set cmd $action
  } {
    set cmd [$self.cmd get]
  }
  catch {send [$self slot _interp] $cmd} stuff
  $self.value set $stuff
}

defmethod Debugger Windows {action} {

  Ilist new $self.ilist \
	-layout center \
	-text "Window Hierarchy of [$self slot _interp]" \
	-initmethod form \
	-init [list $self _windows] \
	-buttons {Edit} \
	-actions [list [list Edit Inspect $self _windowinfo]]
}

defmethod Debugger Help {action} {

  $self Help debugger
}

#---------------------------------------------------------------------------

defmethod Debugger _windows {} {

  set interp [$self slot _interp]

  if {[catch {send $interp "info tclversion"} result] != 0} {
    $self.status set $result
    return
  }
  _debugger(windowsWalk) $interp 0 .
}

proc _debugger(windowsWalk) {interp level window} {

  set list [list [list $level $window \
			[send $interp [list winfo class $window]]]]
  incr level
  foreach child [send $interp [list winfo children $window]] {
    eval [concat lappend list [_debugger(windowsWalk) $interp $level $child]]
  }
  return $list
}

defmethod Debugger _windowinfo {path} {

  set interp [$self slot _interp]

  set path [lindex $path 2]
  if { $path == "." } { return }

  set alist {}
  lappend alist \
	[list const {Window Class} \
		[send $interp [list winfo class $path]]] \
	[list const {Window Location} \
		[list [send $interp [list winfo rootx $path]] \
		      [send $interp [list winfo rooty $path]] \
		      on \
		      [send $interp [list winfo screen $path]] \
		      ]]

  foreach attr [send $interp [list $path configure]] {
    if { [lindex $attr 4] != {} } {
      lappend alist [list const [lindex $attr 1] [lindex $attr 4]]
    }
  }

  Alist new $self.windowinfo \
	-layout center \
	-text "Window Attributes of <$path>" \
	-textfont small \
	-labelfont smallbold \
	-label1 "Attribute" \
	-label2 "Value" \
	-alist $alist

  return
}

Window addDemo Debugger

defmethod Debugger demo {} {

  Debugger new *
}
