#---------------------------------------------------------------------------

defwidget Helpedit Textedit

defmethod Helpedit new {topic} {
  global system

  set file [check(file) Help-$system(language) $topic.help ~]

  exec touch $file

  set top [Toplevel new * -title "Edit Help File '$topic'" -resizable true]
  Button new $top.quit -layout {bottom padx 10 pady 10} \
	-textfont large -text Dismiss \
	-action [list $top Dismiss]
  Button new $top.save -layout {bottom padx 10 pady 10} \
	-textfont large -text Save \
	-action [list $top.t Save [list $top.t save-Formatted $file]]
  Textedit new $top.t -embedded true -initmethod Formatted -init $file \
	-layout {top expand fill} -raw true
  $top layout center
  return $top
}

Window addDemo Helpedit

defmethod Helpedit demo {} {

  Helpedit new foo
}
