proc busy {args} {
    global errorInfo errorCode

    if ![catch {input ._busy -cursor watch}] {
	place ._busy -x 0 -y 0 -relw 1 -relh 1
	set busy ._busy
    } else {
	set busy {}
    }

#   assumes that all toplevel's are children of .

    foreach w [winfo children .] {
	if {[winfo toplevel $w] == $w} {
	    if ![catch {input $w._busy -cursor watch}] {
		place $w._busy -x 0 -y 0 -relw 1 -relh 1
		lappend busy $w._busy
	    }
	}
    }

    update idletasks
    focus none

    if [set error [catch {uplevel eval $args} result]] {
	set ei $errorInfo
	set ec $errorCode
    }

    foreach w $busy {
	# window may have gone away as result of executing $args
	catch {destroy $w}
    }

    if $error {
	error $result $ei $ec
    } else {
	return $result
    }
}
