 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File:	static.tcl
#
# Description:
#	`static' command for Tcl.
#
# Acknowledgement:
#	This file was kindly provided by Karl Lehenbauer of
#	NeoSoft Communications Services.

 # $Id: static.tcl,v 1.9 1993/11/01 18:20:46 kennykb Exp $
 # $Source: /homedisk/julius/u0/kennykb/src/tkauxlib_ship/RCS/static.tcl,v $
 # $Log: static.tcl,v $
 # Revision 1.9  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.8  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.7  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.6  1993/10/20  19:04:11  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.5  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.4  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.3  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.2  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.1  1993/06/03  13:21:35  kennykb
 # Initial revision
 #

# Procedure:	static
#
# Synopsis:
#	Declare one or more static variables.
#
# Usage:
#c	static ?variable?...
#
# Parameters:
#c	variable
#		Name of a static variable
#
# Return value:
#	None.
#
# Description:
#	`static' declares that a given variable or set of variables persists
#	between invocations of the procedure that contains it.  It
#	does so by making the variable global, but prepending to it the
#	name of the containing procedure plus a colon.

proc static {args} {
    set procName [lindex [info level [expr [info level]-1]] 0]
    foreach varName $args {
	uplevel 1 "upvar #0 $procName:$varName $varName"
    }
}





























































To use it, invoke "static" with the names of your static variables as
arguments.  "static" will create the variables as globals named
your_proc_name:your_var_name and use upvar to link them to your names 
in the local namespace.

It works just fine for arrays, too.

Below is a demo procedure.  The first time through it sets the static
staticTestVar variable to 0.  Subsequently it will increment the variable
and echo the variable.  If static wasn't working, the variable would print 
as 0 every time.

proc testproc {} {
    static staticTestVar

    if ![info exists staticTestVar] {
        set staticTestVar 0
    } else {
        incr staticTestVar
    }
    echo "staticTestVar static var is $staticTestVar"
}

testproc
testproc
testproc

It will also be easy to write in C.  Just ripoff upvar.

This raises the question, what is a benchmark for the powerfulness of
a language?  No fibonacci or sieve benchmark is going to reveal it.
-- 
-- Email me for info on getting interactive Internet access.
You are the information elite.  So post an important 
message to alt.tv.dinosaurs.barney.die.die.die right away!


