 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


 # $Header: /homedisk/julius/u0/kennykb/src/tkauxlib_ship/RCS/require.tcl,v 1.9 1993/11/01 18:20:46 kennykb Exp $
 # Require -- Auto-load a command if it's not already defined
 # $Log: require.tcl,v $
 # Revision 1.9  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.8  1993/10/29  17:44:29  kennykb
 # Procedure to force auto-load of a command.
 #
 # Revision 1.7  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.6  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.5  1993/10/20  19:04:11  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.4  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.3  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.2  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.1  1993/10/14  13:46:14  kennykb
 # Initial revision
 #

# Procedure: require
# 
# Synopsis:
#	Force auto_load of a command
#
# Syntax:
#c	require commandName
#
# Parameters:
#c	commandName
#		Name of the command to autoload.
#
# Return value:
#	1 if the load was successful, and 0 otherwise.
#
# Description:
#	The `require' command forces auto_load of another command.  It is used
#	to protect against situations where the `unknown' command might
#	be entered recursively.

proc require {command} {
	if {[llength [info procs $command]] != 0} {
		return 1
	} else {
		return [auto_load $command]
	}
}
