proc parse_hyper_text {t txt} {
  set mode TEXT
  set UnderLine 0
  set Bold 0
  set but_num 0
  set font [$t cget -font]
  set boldfont $font

#convert font to boldfont
  if {$font != ""} {
    set i 0
    set num 0
    while 1 {
      if {[string index $font $i] == "-"} {incr num}
      if {$num == 3} break;
      if {[string index $font $i] == ""} break;
      incr i
    }
    if {$num == 3} {
      set i1 $i
      incr i
      while 1 {
        if {[string index $font $i] == "-"} {incr num}
        if {$num == 4} break;
        if {[string index $font $i] == ""} break;
        incr i
      }
      set i2 $i
      if {$num == 4} {
        set boldfont [string range $font 0 $i1]bold[string range $font $i2 end] 
      } 
    } 
  }
  $t delete 0.0 end
  for {set i 0} {$i < [string length $txt]} {incr i} {
    set chr [string index $txt $i]
    if {$mode == "SKIP"} {
      set word [string range $txt $i [expr $i+1]]
      if {$word == "/D"} {
        set mode TEXT
        incr i
      }
      continue
    }
    if {$mode == "TEXT"} {
      if {$chr == "/"} {set mode NEW_CMD
      } else {
        $t insert end $chr
        if {$UnderLine == 1} {
          $t tag add ul end-2c
          $t tag config ul -underline 1
        }
        if {$Bold == 1} {
          $t tag add bold end-2c
          $t tag config bold -font $boldfont
        }
      }
    } elseif {$mode == "NEW_CMD"} {
      if {$chr == "/"} {
        $t insert end $chr
        set mode TEXT
      }

# Add your own commands here 

      if {$chr == "B"} {
        set tmp [string range $txt [expr $i+1] end]
        button $t.b$but_num -text [lindex $tmp 0] -command [lindex $tmp 1] -padx 2 -pady 0 -highlightthickness 0 -borderwidth 1 -cursor hand2
        while 1 {
          set tmp [lrange $tmp 2 end]
          if {[lindex $tmp 0] == "/D"} break;
          if {[lindex $tmp 1] == "/D"} break;
          if {$tmp == {}} break;
          catch "$t.b$but_num config [lindex $tmp 0] [lindex $tmp 1]"
        }
        $t window create end -window $t.b$but_num -padx 1 -pady 1
        incr but_num
        set mode SKIP
      } elseif {$chr == "u"} {
        set UnderLine 1
        set mode TEXT
      } elseif {$chr == "r"} {
        set UnderLine 0
        set mode TEXT
      } elseif {$chr == "b"} {
        set Bold 1
        set mode TEXT
      } elseif {$chr == "m"} {
        set Bold 0
        set mode TEXT
      } elseif {$chr == "n"} {
        set UnderLine 0
        set Bold 0
        set mode TEXT
      }
    }
  }
}
