proc proc_edit {w} {

  catch "destroy .proc_edit"
  #- TOP LEVEL -----------------------------------------
  toplevel .proc_edit 
  wm title .proc_edit "Procedures/Bindings for $w"
  wm minsize .proc_edit 10 10
  
  set Name .proc_edit
  set Parent $Name
  
  set Name $Parent.f20
  #------------------------------------------
  frame $Name -borderwidth 2 -height 50 -relief ridge -width 50
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f20.l28
  #------------------------------------------
  label $Name -text Procedure:
  pack $Name -anchor nw -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f20.group43
  #------------------------------------------
  frame $Name -borderwidth 2 -height 50 -relief raised -width 285
  pack $Name -anchor center -expand 1 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f20.group43.b40
  #------------------------------------------
  button $Name -text Add: -command "add_proc $w $Parent.f20.group43.e42 $Parent.f20.f0.lb1 $Parent.f12.t13"
  pack $Name -anchor nw -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
  
  set Name $Parent.f20.group43.b21
  #------------------------------------------
  button $Name -text Delete: -command "delete_proc $w $Parent.f20.group43.e42 $Parent.f20.f0.lb1 $Parent.f12.t13"
  pack $Name -anchor center -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
  
  set Name $Parent.f20.group43.b400
  #------------------------------------------
  button $Name -text "Create Binding:" -command "create_binding $w $Parent.f20.group43.e42 $Parent.f20.f0.lb1 $Parent.f12.t13"
  pack $Name -anchor nw -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left

  set Name $Parent.f20.group43.e42
  #------------------------------------------
  entry $Name 
  pack $Name -anchor center -expand 1 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side left
  bind $Name <Return> ""
  
  set Name $Parent.f20.f0
  #------------------------------------------
  frame $Name -borderwidth 1 -height 50 -relief raised -width 50
  pack $Name -anchor center -expand 1 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f20.f0.lb1
  set LB $Name
  #------------------------------------------
  listbox $Name -height 5 -width 0 -yscrollcommand {.proc_edit.f20.f0.sb2 set}
  pack $Name -anchor center -expand 1 -fill both -ipadx 0 -ipady 0 -padx 5 -pady 5 -side left
  bind $Name <ButtonRelease-1> "show_proc $w $LB $Parent.f12.t13"
  

  set Name $Parent.f20.f0.sb2
  #------------------------------------------
  scrollbar $Name -command {.proc_edit.f20.f0.lb1 yview}
  pack $Name -anchor center -expand 0 -fill y -ipadx 0 -ipady 0 -padx 5 -pady 5 -side left
  
  set Name $Parent.f20.l48
  #------------------------------------------
  label $Name -text Code:
  pack $Name -anchor nw -expand 0 -fill none -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f12
  #------------------------------------------
  frame $Name -height 50 -relief raised -width 50
  pack $Name -anchor center -expand 1 -fill both -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f12.t13
  #------------------------------------------
  text $Name -width 60 -yscrollcommand {.proc_edit.f12.sb14 set} -setgrid 1
  pack $Name -anchor center -expand 1 -fill both -ipadx 0 -ipady 0 -padx 5 -pady 5 -side left
  
  set Name $Parent.f12.sb14
  #------------------------------------------
  scrollbar $Name -command {.proc_edit.f12.t13 yview}
  pack $Name -anchor center -expand 0 -fill y -ipadx 0 -ipady 0 -padx 5 -pady 5 -side left
  
  set Name $Parent.f15
  #------------------------------------------
frame $Name -borderwidth 2 -height 50 -relief ridge -width 50
  pack $Name -anchor center -expand 0 -fill x -ipadx 0 -ipady 0 -padx 0 -pady 0 -side top
  
  set Name $Parent.f15.b17
  #------------------------------------------
  button $Name -text Appy -command "apply_proc_edit $w $Parent.f12.t13"
  pack $Name -anchor center -expand 1 -fill x -ipadx 0 -ipady 0 -padx 5 -pady 5 -side left
  
  set Name $Parent.f15.b18
  #------------------------------------------
  button $Name -text Done -command "apply_proc_edit $w $Parent.f12.t13;destroy $Parent"
  pack $Name -anchor center -expand 1 -fill x -ipadx 0 -ipady 0 -padx 5 -pady 5 -side left
  
  set Name $Parent.f15.b19
  #------------------------------------------
  button $Name -text Cancel -command "destroy $Parent"
  pack $Name -anchor center -expand 1 -fill x -ipadx 0 -ipady 0 -padx 5 -pady 5 -side left

  scan_procs $w $LB
}

proc scan_procs {w lb} {
  global Procs
  $lb delete 0 end
  if [isset Procs($w)] {
    foreach i $Procs($w) {
      $lb insert end $i
    }
  }
}

proc show_proc {w lb txt} {
  set index [$lb curselection]
  if {$index == ""} return
  $txt delete 0.0 end
  set proc [$lb get $index]
  if {[lindex $proc 0] == "bind"} {
    global Name
    set Name $w
    set Bind [list [eval $proc]]
    $txt insert end "$proc $Bind"
  } else {
    if {[scan $proc "\$Name.%s" prc]==0} {set prc $proc
    } else {set prc $w.$prc}
    $txt insert end "[list proc $prc [info args $prc] [info body $prc]]"
  }
}

proc add_proc {w ent lb txt} {
  global Procs
  set name [$ent get]
  if {$name == ""} {
    gui_warn "Please enter a procedure name first."
    return
  }
  $ent delete 0 end
  add_proc2 $w $name
}

proc add_proc2 {w name {force 0}} {
  set lb .proc_edit.f20.f0.lb1
  set txt .proc_edit.f12.t13
  global Procs Name
  set Name $w
  if ![isset Procs($w)] {set Procs($w) ""}
  if {[lsearch $Procs($w) $name]==-1 || $force} {
    if {[lindex $name 0] == "bind"} {
      eval $name [list [eval $name]]
    } else {
      if {[info proc $name]==""} {
        echo $name doen't exist
        uplevel #0 "proc $name {} {}"
      }
    }
    if {[lsearch $Procs($w) $name]==-1} {
      lappend Procs($w) $name
      $lb insert end $name
      $lb select clear 0 end
      $lb select set end
      show_proc $w $lb $txt
    }
  } else {
    gui_warn "Procedure $name exists for $w."
    return
  }
}

proc delete_proc {w ent lb txt} {
  global Procs
  set index [$lb curselection]
  if {$index == ""} {
    gui_warn "Select a procedure first."
    return
  }
  $txt delete 0.0 end
  set proc [$lb get $index]
  $lb delete $index
  lremove Procs($w) $proc
  if {[lindex $proc 0] == "bind"} { 
    bind $w [lindex $proc 2] ""
    return
  }
}
 
proc apply_proc_edit {w txt} { 
  global Name
  set Name $w
  eval [$txt get 0.0 end]
  eval "set txt [list [$txt get 0.0 end]]"
  echo txt = |$txt|
  if {[lindex $txt 0] == "proc"} {
    set name [lindex $txt 1]
  } elseif {[lindex $txt 0] == "bind"} {
    set name "[lindex $txt 0] [lindex $txt 1] [lindex $txt 2]"
  } else {
    gui_warn "Should be \"proc name args body\" or \"bind window pattern command\"" 
    return
  }
  add_proc2 $w $name 1
}

proc bind_cb {w ent x y b} {
  if {[winfo containing $x $y]!=".showfeedback.msg"} {
    grab release .showfeedback
    destroy .showfeedback
  } else {
    set_bind $w $ent $b
  }
}

proc create_binding {w ent lb txt} {
  set W .showfeedback
  catch "destroy $W"
  menu $W
  message $W.msg -text "Move outside this box when done.\
\nPress anything else in this box to get its binding." \
-aspect 400 -relief groove -borderwidth 2
  $W post [winfo rootx $ent] [expr [winfo rooty $ent]+[winfo height $ent]]
  pack $W.msg
  focus -force $W.msg
  update
  grab $W.msg
  bindtags $W.msg $W.msg
  bindtags $W $W.msg
  bind $W.msg <Any-ButtonPress> "bind_cb $w $ent %X %Y ButtonPress-%b"
  bind $W.msg <Any-ButtonRelease> "bind_cb $w $ent %X %Y ButtonRelease-%b"
  bind $W.msg <Any-Double-ButtonPress> "bind_cb $w $ent %X %Y Double-ButtonPress-%b"
  bind $W.msg <Any-Double-ButtonRelease> "bind_cb $w $ent %X %Y Double-ButtonRelease-%b"
  bind $W.msg <Any-Triple-ButtonPress> "bind_cb $w $ent %X %Y Triple-ButtonPress-%b"
  bind $W.msg <Any-Triple-ButtonRelease> "bind_cb $w $ent %X %Y Triple-ButtonRelease-%b"
  bind $W.msg <Any-Shift-ButtonRelease> \
    "bind_cb $w $ent %X %Y Shift-ButtonRelease-%b"
  bind $W.msg <Any-Control-ButtonRelease> \
    "bind_cb $w $ent %X %Y Control-ButtonRelease-%b"
  bind $W.msg <Any-Shift-Control-ButtonRelease> \
    "bind_cb $w $ent %X %Y Shift-Control-ButtonRelease-%b"

  bind $W.msg <Any-Shift-Double-ButtonRelease> \
    "bind_cb $w $ent %X %Y Shift-Double-ButtonRelease-%b"
  bind $W.msg <Any-Control-Double-ButtonRelease> \
    "bind_cb $w $ent %X %Y Control-Double-ButtonRelease-%b"
  bind $W.msg <Any-Shift-Control-Double-ButtonRelease> \
    "bind_cb $w $ent %X %Y Shift-Control-Double-ButtonRelease-%b"

  bind $W.msg <Any-Shift-Triple-ButtonRelease> \
    "bind_cb $w $ent %X %Y Shift-Triple-ButtonRelease-%b"
  bind $W.msg <Any-Control-Triple-ButtonRelease> \
    "bind_cb $w $ent %X %Y Control-Triple-ButtonRelease-%b"
  bind $W.msg <Any-Shift-Control-Triple-ButtonRelease> \
    "bind_cb $w $ent %X %Y Shift-Control-Triple-ButtonRelease-%b"

  bind $W.msg <Any-Shift-ButtonPress> \
    "bind_cb $w $ent %X %Y Shift-ButtonPress-%b"
  bind $W.msg <Any-Control-ButtonPress> \
    "bind_cb $w $ent %X %Y Control-ButtonPress-%b"
  bind $W.msg <Any-Shift-Control-ButtonPress> \
    "bind_cb $w $ent %X %Y Shift-Control-ButtonPress-%b"

  bind $W.msg <Any-Shift-Double-ButtonPress> \
    "bind_cb $w $ent %X %Y Shift-Double-ButtonPress-%b"
  bind $W.msg <Any-Control-Double-ButtonPress> \
    "bind_cb $w $ent %X %Y Control-Double-ButtonPress-%b"
  bind $W.msg <Any-Shift-Control-Double-ButtonPress> \
    "bind_cb $w $ent %X %Y Shift-Control-Double-ButtonPress-%b"

  bind $W.msg <Any-Shift-Triple-ButtonPress> \
    "bind_cb $w $ent %X %Y Shift-Triple-ButtonPress-%b"
  bind $W.msg <Any-Control-Triple-ButtonPress> \
    "bind_cb $w $ent %X %Y Control-Triple-ButtonPress-%b"
  bind $W.msg <Any-Shift-Control-Triple-ButtonPress> \
    "bind_cb $w $ent %X %Y Shift-Control-Triple-ButtonPress-%b"

if 0 {
  bind $W.msg <Any-Motion> \
    "set_bind $w $ent Motion"
  bind $W.msg <Any-Shift-Motion> \
    "set_bind $w $ent Shift-Motion"
  bind $W.msg <Any-Control-Motion> \
    "set_bind $w $ent Control-Motion"
  bind $W.msg <Any-Shift-Control-Motion> \
    "set_bind $w $ent Shift-Control-Motion"

  bind $W.msg <Any-Shift-Button1-Motion> \
    "bind_cb $w $ent %X %Y Shift-Button1-Motion"
  bind $W.msg <Any-Control-Button1-Motion> \
    "bind_cb $w $ent %X %Y Control-Button1-Motion"
  bind $W.msg <Any-Shift-Control-Button1-Motion> \
    "bind_cb $w $ent %X %Y Shift-Control-Button1-Motion"

  bind $W.msg <Any-Shift-Button2-Motion> \
    "bind_cb $w $ent %X %Y Shift-Button2-Motion"
  bind $W.msg <Any-Control-Button2-Motion> \
    "bind_cb $w $ent %X %Y Control-Button2-Motion"
  bind $W.msg <Any-Shift-Control-Button2-Motion> \
    "bind_cb $w $ent %X %Y Shift-Control-Button2-Motion"

  bind $W.msg <Any-Shift-Button3-Motion> \
    "bind_cb $w $ent %X %Y Shift-Button3-Motion"
  bind $W.msg <Any-Control-Button3-Motion> \
    "bind_cb $w $ent %X %Y Control-Button3-Motion"
  bind $W.msg <Any-Shift-Control-Button3-Motion> \
    "bind_cb $w $ent %X %Y Shift-Control-Button3-Motion"
}
 
  bind $W.msg <Any-KeyPress> \
    "bind_cb $w $ent %X %Y KeyPress-%K"
  bind $W.msg <Any-KeyRelease> \
    "bind_cb $w $ent %X %Y KeyRelease-%K"
  bind $W.msg <Any-Shift-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-KeyPress-%K"
  bind $W.msg <Any-Shift-KeyRelease> \
    "bind_cb $w $ent %X %Y Shift-KeyRelease-%K"
  bind $W.msg <Any-Control-KeyRelease> \
    "bind_cb $w $ent %X %Y Control-KeyRelease-%K"
  bind $W.msg <Any-Shift-Control-KeyRelease> \
    "bind_cb $w $ent %X %Y Shift-Control-KeyRelease-%K"
  bind $W.msg <Any-Shift-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-KeyPress-%K"
  bind $W.msg <Any-Control-KeyPress> \
    "bind_cb $w $ent %X %Y Control-KeyPress-%K"
  bind $W.msg <Any-Shift-Control-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-Control-KeyPress-%K"

  bind $W.msg <Any-Double-KeyPress> \
    "bind_cb $w $ent %X %Y Double-KeyPress-%K"
  bind $W.msg <Any-Double-KeyRelease> \
    "bind_cb $w $ent %X %Y Double-KeyRelease-%K"
  bind $W.msg <Any-Shift-Double-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-Double-KeyPress-%K"
  bind $W.msg <Any-Shift-Double-KeyRelease> \
    "bind_cb $w $ent %X %Y Shift-Double-KeyRelease-%K"
  bind $W.msg <Any-Control-Double-KeyRelease> \
    "bind_cb $w $ent %X %Y Control-Double-KeyRelease-%K"
  bind $W.msg <Any-Shift-Control-Double-KeyRelease> \
    "bind_cb $w $ent %X %Y Shift-Control-Double-KeyRelease-%K"
  bind $W.msg <Any-Shift-Double-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-Double-KeyPress-%K"
  bind $W.msg <Any-Control-Double-KeyPress> \
    "bind_cb $w $ent %X %Y Control-Double-KeyPress-%K"
  bind $W.msg <Any-Shift-Control-Double-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-Control-Double-KeyPress-%K"

  bind $W.msg <Any-Triple-KeyPress> \
    "bind_cb $w $ent %X %Y Triple-KeyPress-%K"
  bind $W.msg <Any-Triple-KeyRelease> \
    "bind_cb $w $ent %X %Y Triple-KeyRelease-%K"
  bind $W.msg <Any-Shift-Triple-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-Triple-KeyPress-%K"
  bind $W.msg <Any-Shift-Triple-KeyRelease> \
    "bind_cb $w $ent %X %Y Shift-Triple-KeyRelease-%K"
  bind $W.msg <Any-Control-Triple-KeyRelease> \
    "bind_cb $w $ent %X %Y Control-Triple-KeyRelease-%K"
  bind $W.msg <Any-Shift-Control-Triple-KeyRelease> \
    "bind_cb $w $ent %X %Y Shift-Control-Triple-KeyRelease-%K"
  bind $W.msg <Any-Shift-Triple-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-Triple-KeyPress-%K"
  bind $W.msg <Any-Control-Triple-KeyPress> \
    "bind_cb $w $ent %X %Y Control-Triple-KeyPress-%K"
  bind $W.msg <Any-Shift-Control-Triple-KeyPress> \
    "bind_cb $w $ent %X %Y Shift-Control-Triple-KeyPress-%K"

}

proc set_bind {w ent b} {
  #echo $w $ent $b
  $ent delete 0 end
  $ent insert end "bind $w <$b>"
}
