#!/usr/local/bin/wish -f
#
# TkBabyNames 4.1
# Written by Tyson Bigler
########################################################################

bind all <Control-q> {exit}
bind all <Control-o> {OpenFile}
bind all <Control-s> {SaveFile $BACKUP "$OpenedFile"}
bind all <Control-n> {EmptyBuffer}
bind all <Control-h> {HelpFeature}

set RCFILE $env(HOME)/.babynamesrc
set VERSION "4.1"
set BOLD "-background green -foreground {} -relief raised -borderwidth 3"
set NORMAL "-background {} -relief flat"
set BWBOLD "-foreground white -background black"
set BWNORMAL "-foreground {} -background {}"

if {[file exists $RCFILE]} {
	source $RCFILE
	cd $TkBabyNamesBin
} else {
	MakeDialog "TkBabyNames was unable to locate $RCFILE.  Please create\
		this file prior to using this program.  See the help feature\
		for more information about the format and content of this file."
	exit
}

wm title . "TkBabyNames $VERSION - $HUSBAND and $WIFE $SURNAME"
wm iconname . " Baby Names"
wm geometry . $MAINGEOM

###########################################################################
# Create Menu Bar
frame .mbar -relief raised -bd 2
frame .dummy -width 10c -height 5m
pack .mbar .dummy -side top -fill x

menubutton .mbar.file -text File -underline 0 -menu .mbar.file.menu
menubutton .mbar.girls -text Girls -foreground hotpink -underline 0\
	-menu .mbar.girls.menu
menubutton .mbar.boys -text Boys -foreground blue -underline 0\
	-menu .mbar.boys.menu
menubutton .mbar.help -text {Help} -underline 0 -menu .mbar.help.menu
pack .mbar.file .mbar.girls .mbar.boys -side left
pack .mbar.help -side right

menu .mbar.file.menu
	.mbar.file.menu add command -label "Open..." -command OpenFile\
		-accelerator "Ctrl-o"
	.mbar.file.menu add command -label "Save" -accelerator "Ctrl-s" \
		-command {SaveFile $BACKUP "$OpenedFile"}
	.mbar.file.menu add separator
	.mbar.file.menu add command -label "Empty buffer" -accelerator "Ctrl-n"\
		-command EmptyBuffer
	.mbar.file.menu add separator
	.mbar.file.menu add command -label "Quit" -accelerator "Ctrl-q" \
		-command {exit}

menu .mbar.girls.menu
	.mbar.girls.menu add command -label "View $WIFE's Names"\
		-command {ShowNames "Girls/$WIFE"}
	.mbar.girls.menu add command -label "View $WIFE's Combinations"\
		-command {ShowNames "Girls/$WIFE-combo"}
	.mbar.girls.menu add command -label "Make $WIFE's Combinations"\
		-command {MakeCombos "Girls/$WIFE"}
	.mbar.girls.menu add separator
	.mbar.girls.menu add command -label "View $HUSBAND's Names"\
		-command {ShowNames "Girls/$HUSBAND"}
	.mbar.girls.menu add command -label "View $HUSBAND's Combinations"\
		-command {ShowNames "Girls/$HUSBAND-combo"}
	.mbar.girls.menu add command -label "Make $HUSBAND's Combinations"\
		-command {MakeCombos "Girls/$HUSBAND"}
	.mbar.girls.menu add separator
	.mbar.girls.menu add command -label {View Names A thru D}\
		-command {NameChoices "Girls/TkGirlNames.ad"}
	.mbar.girls.menu add command -label {View Names E thru H}\
		-command {NameChoices "Girls/TkGirlNames.eh"}
	.mbar.girls.menu add command -label {View Names I thru L}\
		-command {NameChoices "Girls/TkGirlNames.il"}
	.mbar.girls.menu add command -label {View Names M thru P}\
		-command {NameChoices "Girls/TkGirlNames.mp"}
	.mbar.girls.menu add command -label {View Names Q thru T}\
		-command {NameChoices "Girls/TkGirlNames.qt"}
	.mbar.girls.menu add command -label {View Names U thru Z}\
		-command {NameChoices "Girls/TkGirlNames.uz"}

menu .mbar.boys.menu
	.mbar.boys.menu add command -label "View $WIFE's Names"\
		-command {ShowNames "Boys/$WIFE"}
	.mbar.boys.menu add command -label "View $WIFE's Combinations"\
		-command {ShowNames "Boys/$WIFE-combo"}
	.mbar.boys.menu add command -label "Make $WIFE's Combinations"\
		-command {MakeCombos "Boys/$WIFE"}
	.mbar.boys.menu add separator
	.mbar.boys.menu add command -label "View $HUSBAND's Names"\
		-command {ShowNames "Boys/$HUSBAND"}
	.mbar.boys.menu add command -label "View $HUSBAND's Combinations"\
		-command {ShowNames "Boys/$HUSBAND-combo"}
	.mbar.boys.menu add command -label "Make $HUSBAND's Combinations"\
		-command {MakeCombos "Boys/$HUSBAND"}
	.mbar.boys.menu add separator
	.mbar.boys.menu add command -label {View Names A thru D}\
		-command {NameChoices "Boys/TkBoyNames.ad"}
	.mbar.boys.menu add command -label {View Names E thru H}\
		-command {NameChoices "Boys/TkBoyNames.eh"}
	.mbar.boys.menu add command -label {View Names I thru L}\
		-command {NameChoices "Boys/TkBoyNames.il"}
	.mbar.boys.menu add command -label {View Names M thru P}\
		-command {NameChoices "Boys/TkBoyNames.mp"}
	.mbar.boys.menu add command -label {View Names Q thru T}\
		-command {NameChoices "Boys/TkBoyNames.qt"}
	.mbar.boys.menu add command -label {View Names U thru Z}\
		-command {NameChoices "Boys/TkBoyNames.uz"}

menu .mbar.help.menu
	.mbar.help.menu add command -label {Help Index} -command HelpFeature \
		-accelerator "Ctrl-h"
	.mbar.help.menu add separator
	.mbar.help.menu add command -label {About TkBabyNames} -command {
		AboutTkBabyNames}

tk_menuBar .mbar .mbar.file .mbar.girls .mbar.boys .mbar.help

###########################################################################
# Create display area
frame .display
text .display.text -height 25 -width 30 -relief sunken -bd 4 \
	-yscrollcommand ".display.scroll set" -font $MYFONT -wrap word
scrollbar .display.scroll -command ".display.text yview"
pack .display.scroll -in .display -side right -fill y
pack .display.text -in .display -side left
pack .display
.display.text configure -state disabled

###########################################################################
# Show list of preferred names
proc ShowNames {File} {
	.display.text configure -state normal
	set f [open "$File" r]
	while {[gets $f Line] != -1} {
		if {$Line == ""} {
			continue
		} else {
			.display.text insert end "$Line\n"
			.display.text see end
			update
		}
	}
	close $f
	.display.text insert end \n\n
	.display.text configure -state disabled
}

###########################################################################
# Make all possible combinations of preferred names
proc MakeCombos {File} {
	global SURNAME CHECK WIFE HUSBAND
	set CHECK "$File"
	MakeListbox combos
	set f [open "$File" r]
	set Possibilities [lsort [read $f 1000]]
	close $f
	set AddTo $Possibilities
	WatchCursor
	foreach i $Possibilities {
		foreach j $AddTo {
			if {$i == $j} {
				continue
			} elseif {$i == ""} {
				continue
			} elseif {$j == ""} {
				continue
			} else {
				.combos.main.list insert end "$i $j $SURNAME\n"
				update
			}
		}
	}
	button .combos.but.h -text $HUSBAND -command {
		if [string match Girl* "$CHECK"] {
			AppendName $BACKUP "Girls/$HUSBAND-combo" \
				[selection get]
		} elseif [string match Boy* "$CHECK"] {
			AppendName $BACKUP "Boys/$HUSBAND-combo" \
				[selection get]
		}
		MakeDialog "[selection get] appended to $HUSBAND's file."
	}
	button .combos.but.w -text $WIFE -command {
		if [string match Girl* "$CHECK"] {
			AppendName $BACKUP "Girls/$WIFE-combo" [selection get]
		} elseif [string match Boy* "$CHECK"] {
			AppendName $BACKUP "Boys/$WIFE-combo" [selection get]
		}
		MakeDialog "[selection get] appended to $WIFE's file."
	}
	pack .combos.but.h .combos.but.w -side left -expand 1 -fill x
	NormalCursor
}

###########################################################################
# Read from master list of names
proc NameChoices {File} {
	global CHECK WIFE HUSBAND
	set CHECK "$File"
	MakeListbox choices
	set f [open "$File" r]
	set Choices [lsort [read $f 1000]]
	close $f
	WatchCursor
	foreach i $Choices {
		if {$i == ""} {
			continue
		} else {
			.choices.main.list insert end "$i\n"
		}
	}
	button .choices.but.h -text "$HUSBAND" -command {
		if [string match Girl* "$CHECK"] {
			AppendName $BACKUP "Girls/$HUSBAND" [selection get]
		} elseif [string match Boy* "$CHECK"] {
			AppendName $BACKUP "Boys/$HUSBAND" [selection get]
		}
		MakeDialog "[selection get] appended to $HUSBAND's file."
	}
	button .choices.but.w -text "$WIFE" -command {
		if [string match Girl* "$CHECK"] {
			AppendName $BACKUP "Girls/$WIFE" [selection get]
		} elseif [string match Boy* "$CHECK"] {
			AppendName $BACKUP "Boys/$WIFE" [selection get]
		}
		MakeDialog "[selection get] appended to $WIFE's file."
	}
	pack .choices.but.h .choices.but.w -side left -expand 1 -fill x
	NormalCursor
}

###########################################################################
# Make listboxes
proc MakeListbox {Title} {
	global MYFONT WIFE HUSBAND BACKUP
	toplevel .$Title

	frame .$Title.main
	listbox .$Title.main.list -height 20 -width 30 -relief sunken -bd 2 \
		-yscrollcommand ".$Title.main.scroll set" -selectforeground\
		black -selectbackground green -font $MYFONT
	scrollbar .$Title.main.scroll -command ".$Title.main.list yview"
	pack .$Title.main.scroll -side right -fill y
	pack .$Title.main.list
	pack .$Title.main

	frame .$Title.but
	button .$Title.but.d -text Dismiss -command "destroy .$Title"
	pack .$Title.but.d -expand 1 -fill x
	pack .$Title.but -fill x -expand 1
}

###########################################################################
# Add the selected name to the appropriate file
proc AppendName {Backup File Name} {
	if {$Backup == 1} {
		exec cp $File $File~
		set TEMP [open "tkbabytemp" w]
		puts $TEMP $Name
		close $TEMP
		exec cat tkbabytemp >> $File
	} else {
		set TEMP [open "tkbabytemp" w]
		puts $TEMP $Name
		close $TEMP
		exec cat tkbabytemp >> $File
	}
}

###########################################################################
# Help routine
proc HelpFeature {} {
	global MYFONT VERSION WIFE HUSBAND BOLD NORMAL BWBOLD BWNORMAL RCFILE
	toplevel .help
	wm title .help "TkBabyNames Help Feature"
	wm iconname .help "Help"
	NormalCursor

	frame .help.but
	pack .help.but -side bottom -expand 1 -fill x -padx 2m -pady 2m
	button .help.but.dismiss -text Dismiss -command "destroy .help"
	pack .help.but.dismiss -side left -expand 1 -fill x

	frame .help.view
	text .help.view.text -width 60 -height 15 -font $MYFONT -wrap word \
		-yscrollcommand ".help.view.scroll set" -setgrid 1
	scrollbar .help.view.scroll -command ".help.view.text yview"
	pack .help.view.scroll -side right -fill y
	pack .help.view.text -expand 1 -fill both
	pack .help.view

	if {[winfo depth .help] > 1} {
		set bold $BOLD
		set normal $NORMAL
	} else {
		set bold $BWBOLD
		set normal $BWNORMAL
	}

	.help.view.text insert end \
"Thank you for using TkBabyNames $VERSION."
	.help.view.text insert end \n\n
	.help.view.text insert end \
{You may select a topic from the following list by moving the\
pointer over the selection and clicking on it.}
	.help.view.text insert end \n\n
	.help.view.text insert end \t
	.help.view.text insert end \
"Format and content of $RCFILE" d1
	.help.view.text insert end \n\n
	.help.view.text insert end \t
	.help.view.text insert end \
{"Starter" name files included with TkBabyNames} d2
	.help.view.text insert end \n\n
	.help.view.text insert end \t
	.help.view.text insert end \
{Using the FILE menu} d3
	.help.view.text insert end \n\n
	.help.view.text insert end \t
	.help.view.text insert end \
{Using the BOYS and GIRLS menus} d4

	foreach tag {d1 d2 d3 d4} {
		.help.view.text tag bind $tag <Any-Enter> \
			".help.view.text tag configure $tag $bold"
		.help.view.text tag bind $tag <Any-Leave> \
			".help.view.text tag configure $tag $normal"
	}

	.help.view.text tag bind d1 <1> {
		HelpWindow help1 {The RC file should exist in the user's home\
directory and be named .babynamesrc.  The format and content of the file is\
very simple.  There are only six variables to be defined and their format is\
as follows:

set WIFE "place your wife's name in here"
set HUSBAND "place your name in here"
set SURNAME "place your last name here"
set MYFONT "place your favorite font here"
set BACKUP "either 1 or 0 for true or false"
set TkBabyNamesBin "path to TkBabyNames"

As you can see, that's really easy!  The install program will have created\
this file for you using the options you specified for each of the questions.\
Should you want to change any of them you can just edit the rc file--you don't\
need to run the installation again.
}
}

	.help.view.text tag bind d2 <1> {
		HelpWindow help2 {You will notice that there are two tar files\
included with this distribution. They each contain six files of sample names,\
one each for boys and girls.  All names are certainly not represented.  I\
simply took a *small* booklet of common current baby names and used it.  If\
you have a name in mind that is not included in these lists, not to worry!\
You may simply add the name manually by opening the correct file and typing\
it in.  More on that under the help section "Using the FILE menu".
}
}

	.help.view.text tag bind d3 <1> {
		HelpWindow help3 "The File menu has several options, all of\
which are bound to hot keys.

You may use the OPEN command to open one of the eight working files\
containing your family's preferred names.  The eight files are:
	../Boys/$HUSBAND
	../Boys/$HUSBAND-combo
	../Boys/$WIFE
	../Boys/$WIFE-combo
	../Girls/$HUSBAND
	../Girls/$HUSBAND-combo
	../Girls/$WIFE
	../Girls/$WIFE-combo
The selected file will be opened in the display area for editing.\
You may add, delete, or change the spelling of any of the names.\
The files with just you or your spouse's name contain the single names\
each of you are interested in, while the files ending in -combo contain\
full names that you have selected to be saved from the Make Combinations\
listing.

The SAVE command will save whichever file you are working on.  If you have\
elected to have backups made, a backup copy will be created first.

The EMPTY BUFFER command will clear the display area.

The QUIT command obviously exits the application.
"
}

	.help.view.text tag bind d4 <1> {
		HelpWindow help4 "The GIRLS and BOYS menus each contain many\
options which are bacically the same (only one's for boy names and the other\
is for girl names).  We'll describe what each option does:

VIEW $WIFE's/$HUSBAND's NAMES each show the respective spouse's list of\
preferred names in a non-editable window.

VIEW $WIFE's/$HUSBAND's COMBINATIONS each show the respective spouse's\
list of preferred full names in a non-editable window.

MAKE $WIFE's/$HUSBAND's COMBINATIONS each generate all the possible\
name combinations from the respective spouse's list of preferred names\
and inserts them into a listbox.  You may then select a full name which\
pleases you and save it by highlighting the name and clicking on your\
name at the bottom.  You may then view these names with the above mentioned\
option.  This saves you from regenerating the list over and over when you\
really don't want to see *all* the combinations.

VIEW NAMES A THRU D (and the rest of them) generate a list of names from\
which to choose.  These are what I've referred to as starter files.\
These are provided to get you started with your personal name files.\
The same method applies here as above; if you see a name you like\
highlight it and click on your name at the bottom for it to be saved\
to your own personal file.
"
}
}

proc HelpWindow {WinTop HelpView} {
	global MYFONT
	toplevel .$WinTop
	frame .$WinTop.main
	text .$WinTop.main.text -width 60 -height 15 -font $MYFONT -wrap word \
		-yscrollcommand ".$WinTop.main.scroll set" -setgrid 1
	scrollbar .$WinTop.main.scroll -command ".$WinTop.main.text yview"
	button .$WinTop.main.dismiss -text Dismiss -command "destroy .$WinTop"
	pack .$WinTop.main.scroll -side right -fill y
	pack .$WinTop.main.text -expand 1 -fill both
	pack .$WinTop.main.dismiss -side bottom -expand 1 -fill x
	pack .$WinTop.main
	.$WinTop.main.text insert end $HelpView
}

proc AboutTkBabyNames {} {
		HelpWindow about {TkBabyNames was written by Tyson Bigler using Tcl/Tk\
(7.4/4.0).  This distribution is OPINION-ware; in other words you are free to\
use this software provided you send an e-mail message to the author telling\
him that you're using it and whether you like it or not.  In addition, you may\
distribute this program to your friends provided that the following conditions\
are met:

	1. You do NOT distribute a modified version in any form
	2. You do NOT charge that person for this software

All of the other standard disclaimers apply.  There is no warranty made or\
implied by the author.  I am not responsible for any damage these programs may\
do to your system, loss of data, etc.  This software is provided as is--take it\
or leave.

I know for a fact that my code is not the best written or most efficient, but\
if you'd like to look at it you're obviously welcome to do so.  There isn't\
any trickery involved with this program--simple Tcl/Tk.  Additionally, if\
anyone has any suggestions on how to improve this just drop me a note.

The author may be reached at bigler@texas.net
}
}

###########################################################################
# Open file 
proc OpenFile {} {
	global WIFE HUSBAND
	MakeListbox filelist
	NormalCursor
	foreach i [lsort [glob -nocomplain Girls/$WIFE Girls/$HUSBAND\
		Girls/$WIFE-combo Girls/$HUSBAND-combo Boys/$WIFE \
		Boys/$HUSBAND Boys/$WIFE-combo Boys/$HUSBAND-combo]] {
		.filelist.main.list insert end $i
	}
	button .filelist.but.open -text Open -command {
		.display.text configure -state normal
		.display.text delete 1.0 end
		set OpenedFile [selection get]
		set f [open "[selection get]" r]
		while {![eof $f]} {
			.display.text insert end [read $f 1000]
		}
		close $f
		destroy .filelist
	}
	pack .filelist.but.open -side left -fill x -expand 1
}

###########################################################################
# Save file
proc SaveFile {Backup File} {
	if {$Backup == 1} {
		exec mv $File $File~
	}
	set f [open "$File" w]
	puts $f [.display.text get 1.0 end]
	close $f
	.display.text delete 1.0 end
	.display.text configure -state disabled
}

###########################################################################
# Empty the display area
proc EmptyBuffer {} {
	.display.text configure -state normal
	.display.text delete 1.0 end
	.display.text configure -state disabled
}

###########################################################################
# Generate Dialog Boxes
proc MakeDialog {DText} {
	tk_dialog .dialog {For Your Information} "$DText" "" 0 Okay
}

###########################################################################
# Change cursor appropriately
proc WatchCursor {} {
	foreach w [winfo children .] {
		lappend busy [list $w [lindex [$w config -cursor] 4]]
	}
	foreach w $busy {catch {[lindex $w 0] config -cursor watch}}
	update idletasks
}
proc NormalCursor {} {
	foreach w [winfo children .] {
		lappend notbusy [list $w [lindex [$w config -cursor] 4]]
	}
	foreach w $notbusy {catch {[lindex $w 0] config -cursor hand2}}
	update idletasks
}
