#!/usr/cluster/bin/wish -f
#
# UserMaint V1.0 by Charles A. Eads
#
# Copyright (c) 1993 The Regents of the University of California.
# All rights reserved.
# 
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose, without fee, and without written agreement is
# hereby granted, provided that the above copyright notice and the following
# two paragraphs appear in all copies of this software.
# 
# IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
# DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
# OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
# CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
# 
# THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
# AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.


# Load usermaint-config file.
source usermaint-config

#
wm title . "UserMaint V1.0 by Charles A. Eads"

# Load external files.
foreach f \
{
	utility.tcl
	userlist.tcl
	passwd-manip.tcl
	group-manip.tcl
	useredit.tcl
	useredit-group.tcl
	useredit-passwd.tcl
	add.tcl
	edit.tcl
	apply.tcl
	usermaint-hooks
} {source $f}

#default values
set window_number 1
set active_delete 0

if {[passwd_lock] != 0} \
{
	puts stderr "Unable to lock passwd file."
	exit
}
if {[passwd_global_lock] != 0} \
{
	puts stderr "Unable to globaly lock the passwd file."
	passwd_unlock
	exit
}

title.tcl &

set passwd_text [passwd_init $PASSWD_FILE_NAME]
set group_text [group_init $GROUP_FILE_NAME]

set userlist_deleted {}

# Pass control on to control code.
source control.tcl
