# hdr.t --- article header procs

# XXX - need to find out exact criteria for line continuations
#
# read a header from the supplied 'hdr_line' into associative array 
# with name 'hdr_bag'. The end of header is defined by 'stopline'. 
# if a line matches 'stopline' then )  is returned. The 'stop_line' is
# not placed in 'hdr_bag'. lines starting with a tab or space are 
# considered continuations of the previous line.
#
# Returns:
#      -1 illegal header line ignored (eg no colon)
#	1 hdr_line line is ok. it has been placed into hdr_bag
#       0 header complete
#
set previous_hdrAdd_tag ""
proc hdrAdd {hdr_line hdr_bag} {
    global previous_hdrAdd_tag
    # the  uplevels below allows us to 'pass' the array as return parameter
    # also note the use of the list command. This escapes brackets etc...
    case $hdr_line { "" "\r" \n" "\r\n" "\r\n" } {
	set previous_hdrAdd_tag ""
	return 0
    } { "\t*" " *"} {
	# continuation line add to the last one we did...
	if {$previous_hdrAdd_tag!=""} {
	    # XXX
	    # how should concatenation be done ??? right now we strip off
	    # the tab
	    uplevel 1 append [set hdr_bag]($previous_hdrAdd_tag) \
		[list [string trimright [string range $hdr_line 1 end] "\r\n"]]
	    return 1
	}
    } default {
	if {[regexp {([^: 	]+): (.*)} $hdr_line junk tag value]} {
	    set previous_hdrAdd_tag $tag
	    uplevel 1 set [set hdr_bag]($tag) [string trim [list $value] "\r\n"]
	    return 1
	}
    }
    set previous_hdrAdd_tag ""
    return -1
}

# return a list of <messageid>'s
# from string 'line'
# an empty list is returned if none exist
#
# XXX 
# Note:
#     need to look at RFC's 822 850 1036 to make a better
#     evaluation on what is a valid msg id
#
proc hdrMsgIds {line} {
    set rlist {}
    set line [split $line ""]

    set in_id 0
    foreach c $line {
	if {!$in_id} {
	    if {$c=="<"} { 
		set id "<" 
		set in_id 1
	    }
	} else {
	    case $c "<" {
		# anchor match to right, for <xx<<9999@wlbr.com> extract
		# <999@wlbr.com> not <xx<<<999@wlbr.com>
		set id "<"
	    } ">" {
		append id ">"
		lappend rlist $id
		set in_id 0
	    } {" " \t =   + / } {
		# these do not appear in a msg id
		# so we must not really be in one...
		unset id; set in_id 0
	    } default {
		append id $c
	    }
	}
    }
    return $rlist
}

# return a list of of form
#
#    { {grName artNum} ... {grNameN artNumN} }
#
# given a Xref style header line which is of the form
#
#     Xref hostName grpName artNum grpName2 artNum2.... grpNameN artNumN
#
# if no such pairs exist or the line does not have the proper Xref hostname
# prefix an empty list is returned
#
set hdrXrefsErrorCount 0
proc hdrXrefs {hname line} {
    global hdrXrefsErrorCount
    set rval {}
    if {![regexp  {([^ 	]+)[ 	]+(.*)} $line\
    	 junk host refs]} {
	 puts stderr "# incorrect general format <$line> host=$host refs=$refs"
	 return {}
    } else {
	if {$host!=$hname} {
	    if {$hdrXrefsErrorCount<10} {
		puts stderr "-- incorrect host name $host in Xref header line"
		puts stderr "-- should be '$hname' ???"
		puts stderr "-- perhaps you should setenv NNTPXREFNAME $host"
		puts stderr "-- in your .cshrc"
		incr hdrXrefsErrorCount 1
	    }
	    return {}
	}
	# pick out the grpName artNUm pairs
	foreach r $refs {
	    lappend rval [split $r :]
	}
    }
    return $rval
}
