#include <stdlib.h>
#include "chichotConfig.h"
#include "line_link.h"
#include "agent.h"
#include "myScreen.h"

agent_line_link::agent_line_link()
{
   line = new string();
   sample = 0;
   next = 0;
   alt_branch = 0;
   /*test = none;*/
}

agent_line_link::agent_line_link(agent_line_link& all)
{
   line = new string(all.line->realstr(), all.line->length());
   if (all.sample)
      sample = new string(all.sample->realstr(), all.sample->length());
   else
      sample = 0;
   next = 0;
   alt_branch = 0;
   /*test = all.test;*/
   parent = all.parent;
   line_md = all.line_md;
}

void
agent_line_link::empty()
{
   if (line) {
      line->empty();
      line = 0;
   }
   if (sample) {
      sample->empty();
      sample = 0;
   }
   if (next && next->line)
      next->empty();
   if (alt_branch && alt_branch->line)
      alt_branch->empty();
}

agent_link::agent_link()
{
   name = new string();
   body = new agent_line_link();
   for (short acn = 0; acn < MAX_CONTEXTS; acn++)
      context[acn] = 0;
   next = 0;
}

void
agent_link::empty()
{
  name->empty();
  delete name;
  name = 0;
  body->line->empty();
  delete body->line;
  if (body->sample) {
    body->sample->empty();
    delete body->sample;
  }
  delete body;
  body = 0;
}

agent::agent()
{
/*   actions = new agent_link();
   actions->empty();*/
   init_actions();

}

void
agent::insert_action(string* action_name, line_link* aptr, line_link* endptr)
{
   agent_link* al = new agent_link();
   al->next = actions;
   actions = al;
   *al->name = *action_name;
   for (short cn = 0; cn < MAX_CONTEXTS; cn++)
      if (0 != aptr->context[cn])
	 al->context[cn] =
	    new string(aptr->context[cn]->realstr(),
		       strlen(aptr->context[cn]->realstr()));
      else
	 al->context[cn] = 0;
   agent_line_link* all = 0;
   endptr = endptr->next->next;
   do {
     if (out != endptr->line_md || all && out != all->line_md || !all) {
       al->body = new agent_line_link();
       al->body->next = all;
       all = al->body;
       all->line_md = endptr->line_md;
       if (in == endptr->line_md)
	 *all->line = *endptr->line;
       if (endptr->sample && 0 != endptr->sample->length()) {
	  all->sample = new string(endptr->sample->realstr(),
				   endptr->sample->length());
	  all->parent = all;
       }
     }
     endptr = endptr->next;
   } while (aptr != endptr);
   save_actions();
}

void
agent::insert_alt_action(agent_line_link* ags,
			 line_link* aptr,
			 line_link* endptr)
{
   agent_line_link* alb = 0;
   agent_line_link* all = 0;
   endptr = endptr->next;
   do {
     if (out != endptr->line_md || !all || out != all->line_md) {
       alb = new agent_line_link();
       if (0 == all) {
	  alb->next = ags->parent;
       }
       else {
	  alb->next = all;
       }
       all = alb;
       all->line_md = endptr->line_md;
       if (in == endptr->line_md)
	  *all->line = *endptr->line;
       /*all->test = endptr->test;*/
       if (endptr->sample) {
	  all->sample = new string(endptr->sample->realstr(),
				   endptr->sample->length());
	  all->alt_branch = 0;
       }
       else {
	  all->sample = 0;
       }
       all->parent = ags->parent;
     }
     endptr = endptr->next;
   } while (aptr != endptr);
   while (out == all->line_md) {
      alb = all->next;
      delete all;
      all = alb;
   }
   ags->alt_branch = all;
   save_actions();
}

void
agent::delete_actions()
{
   while (actions->name) {
      agent_link* t = actions;
      if (t->name) {
	 if (t->name->realstr())
	    t->name->empty();
	 delete t->name;
      }
      for (short cn = 0; 0 != t->context[cn]; cn++) {
	 t->context[cn]->empty();
	 delete t->context[cn];
      }
      if (t->body) {
	 t->body->empty();
	 delete t->body;
      }
      actions = t->next;
      delete t;
   }
}

void
agent::save_branch(agent_line_link* d, ofstream& f_out, short circ)
{
   do {
      if (in == d->line_md) {
	 f_out.put('i');
	 f_out.put('\0');
	 f_out.write(d->line->realstr(), d->line->length());
      } else
	 f_out.put('o');
      f_out.put('\0');
      if (0 != d->sample)
	 f_out.write(d->sample->realstr(), d->sample->length());
      if (in == d->line_md)
	 f_out.put('\0');
      if (d->alt_branch) {
	 f_out.write("\nbranch\0\n", 9);
	 save_branch(d->alt_branch, f_out, 0);
	 f_out.write("endbranch\0", 10);
      }
      f_out.put('\n');
      d = d->next;
   } while (0 != d && (circ || d != d->parent));
}

void
agent::save_actions()
{
   ofstream f_out(actionFile, ios::out);
   if (!f_out) {
      cerr << "cannot open " << actionFile;
      exit(1);
   }
   agent_link* tmp = actions;
   string* n = tmp->name;
   while (n != 0) {
      f_out.write("action ", 7);
      f_out.write(n->realstr(), n->length());
      f_out.write("\ncontexts", 10);
      if (0 == tmp->context[0]) {
         cerr << "Action has no context" << endl;
         exit(-1);
      }
      f_out.write(tmp->context[0]->realstr(),
                     tmp->context[0]->length());
      for (short cn = 1; tmp->context[cn] != 0; cn++) {
	 f_out.put('\n');
	 f_out.write(tmp->context[cn]->realstr(),
		     tmp->context[cn]->length());
      }
      f_out.put('\0');
      f_out.put('\n');
      agent_line_link* d = tmp->body;
      if (0 == d) {
	 cerr << "no action definition ";
	 exit(1);
      }
      save_branch(d, f_out, 1);
      tmp = tmp->next;
      n = tmp->name;
      f_out.write("endaction\0\n", 11);
      f_out.flush();
   }
}

void
agent::init_branch(agent_line_link* all, ifstream& f_in, short circ,
		   agent_line_link* parent = 0)
{
   char line[MAX_LINE];
   char def[MAX_DEF];
   char ch;
   short done = 0;
   agent_line_link* ap = all;
   agent_line_link* aprev;
   short expectBranch = 0;
   do {
      short prepnext = 1;
      f_in.get(line, MAX_LINE, '\0');
      if (!strcmp(line, "i") || !strcmp(line, "o")) {
         if (expectBranch) {
            expectBranch = 0;
            ap->next = new agent_line_link();                                      
            aprev = ap;
            ap = ap->next;
         }
	 if (strcmp(line, "i"))
	    ap->line_md = out;
	 else
	    ap->line_md = in;
	 f_in.get(ch);
	 if ('\0' != ch) {
	    cerr << "Error reading branch" << endl;
	    exit(-1);
	 }
	 f_in.get(ch);
	 if (!strcmp(line, "i")) {
	    ap->line = new string(&ch, 1);
	    f_in.get(ch);
	    if ('\0' != ch) {
               cerr << "Error reading branch - input" << endl;
	       exit(-1);
	    }
	    if (!f_in.get(ch)) {
               cerr << "Error reading branch - input" << endl;
	       exit(-1);
	    }
            if (circ)
               ap->parent = ap;
            else
               ap->parent = parent;
	    if ('\0' != ch) {
	       if (!f_in.putback(ch)) {
		  cerr << "Error reading branch - putback" << endl;
		  exit(-1);
	       }
	       f_in.getline(line, MAX_LINE, '\0');
	       ap->sample = new string(line, strlen(line));
               prepnext = 0;
               expectBranch = 1;
            }
            f_in.get(ch);
	 }
         if ('\n' != ch) {
            cerr << "Error reading branch" << endl;
	    exit(-1);
	 }
      } else if (!strcmp(line, "branch")) {
         expectBranch = 0;
         f_in.get(ch);
	 if ('\0' != ch) {
	    cerr << "Expected \\0, but got " << ch << endl;
	    exit(-1);
	 }
	 f_in.get(ch);
	 if ('\n' != ch) {
	    cerr << "Expected \\n, but got " << ch << endl;
	    exit(-1);
	 }
	 ap->alt_branch = new agent_line_link;
	 if (circ)
	    init_branch(ap->alt_branch, f_in, 0, ap);
	 else
	    init_branch(ap->alt_branch, f_in, 0, parent);
      } else if (0 == circ && !strcmp(line, "endbranch") ||
		 1 == circ && !strcmp(line, "endaction")) {
         f_in.get(ch);
	 if ('\0' != ch) {
	    cerr << "Expected \\0, but got " << ch << endl;
	    exit(-1);
	 }
	 f_in.get(ch);
	 if ('\n' != ch) {
	    cerr << "Expected \\n, but got " << ch << endl;
	    exit(-1);
	 }
	 done = 1;
         prepnext = 0;
         delete ap->line;
         delete ap;
         if (!circ)
            aprev->next = parent;
         else
            aprev->next = 0;
      } else {
	 cerr << "Error reading an action" << endl;
	 exit(-1);
      }
      if (prepnext) {
         ap->next = new agent_line_link();
         aprev = ap;
         ap = ap->next;
      }
   } while (!done);
}

void
agent::init_actions()
{
   actions = new agent_link;
   actions->next = 0;
   delete actions->name;
   actions->name = 0;
   delete actions->body;
   actions->body = 0;
   ifstream f_in(actionFile, ios::in);
   if (!f_in) {
      cerr << "cannot open " << actionFile;
      exit(1);
   }
   char line[MAX_LINE];
   char def[MAX_DEF];
   agent_link* p;
   while (f_in.get(line, MAX_LINE, '\n')) {
      if (strncmp(line, "action ", 7)) {
         cerr << "Incorrect action header" << endl;
         exit(-1);
      }
      p = new agent_link();
      p->next = actions;
      actions = p;
      p->name->assign(&line[7], strlen(&line[7]));
      char ch;
      f_in.get(ch);
      if ('\n' != ch || !f_in.get(line, MAX_LINE, '\0') ||
	  strcmp(line, "contexts")) {
	 cerr << "Incorrect context header" << endl;
	 exit(-1);
      }
      f_in.get(ch);
      if ('\0' != ch) {
	 cerr << "Incorrect contexts field" << endl;
	 exit(-1);
      }
      if (!f_in.get(line, MAX_LINE, '\0')) {
	 cerr << "Incorrect contexts field" << endl;
	 exit(-1);
      }
      f_in.get(ch);
      if ('\0' != ch) {
	 cerr << "Incorrect contexts field" << endl;
	 exit(-1);
      }
      short cn = 0;
      int i = 0;
      int j;
      do {
	 j = i;
	 while ('\n' != line[j] && '\0' != line[j]) j++;
	 p->context[cn++] = new string(&line[i], j - i);
	 i = j + 1;
      } while ('\0' != line[j]);
      f_in.get(ch);
      if ('\n' != ch) {
	 cerr << "Incorrect contexts field" << endl;
	 exit(-1);
      }
      p->body = new agent_line_link;
      init_branch(p->body, f_in, 1);
   }
}

agent::~agent()
{
   save_actions();
   delete_actions();
}
