
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

#include "myString.h"

string&
string::assign(const char* &s, const unsigned int slen)
{
     if (str)
	  delete str;
     len = slen;
     str = new char[len + 1];
     memcpy(str, s, slen);
     str[len] = '\0';
     return *this;
}

string&
string::operator=(const string& s)
{
     if (str)
	  delete str;
     len = s.length();
     str = new char[len + 1];
     memcpy(str, s.realstr(), len);
     str[len] = '\0';
     return *this;
}

string&
string::add(const char* &s, const unsigned int slen)
{
   if ('\0' != *s) {
      char* p = new char[len + slen + 1];
      if (str)
	 memcpy(p, str, len);
      memcpy(&p[len], s, slen);
      delete str;
      str = p;
      len += slen;
      str[len] = '\0';
   }
     return *this;
}


string&
string::operator+=(const string& s)
{
     char* p = new char[len + s.length() + 1];
     if (str) {
       memcpy(p, str, len);
       delete str;
     }
     memcpy(&p[len], s.realstr(), s.length());
     str = p;
     len += s.length();
     return *this;
}


string&
string::operator+=(const char s)
{
     char *p = new char[len + 2];
     if (str) {
        memcpy(p, str, len);
        delete str;
     }
     p[len] = s;
     p[++len] = '\0';
     str = p;
     return *this;
}
