# jdoc_cmds.tcl - command procedures for jdoc
#
######################################################################
# Copyright 1992-1995 by Jay Sekora.  This file may be freely        #
# distributed, modified or unmodified, for any purpose, provided     #
# that this copyright notice is retained verbatim in all copies and  #
# no attempt is made to obscure the authorship of this file.  If you #
# distribute any modified versions, I ask, but do not require, that  #
# you clearly mark any changes you make as such and that you provide #
# your users with instructions for getting the original sources.     #
######################################################################

##############################################################################
# jdoc:cmd:about - make the about box
##############################################################################

j:command:register jdoc:cmd:about {About the Doc Viewer...}
proc jdoc:cmd:about { w args } {
  global JSTOOLS_VERSION
  set about_jdoc [j:ldb rt:about_jdoc {
    j:rt:hl "jdoc"
    j:rt:cr
    j:rt:rm "by Jay Sekora, "
    j:rt:tt "js@aq.org"
    j:rt:par
    j:rt:rm "An X Windows application for viewing help files."
    j:rt:cr
    j:rt:rm "Version $JSTOOLS_VERSION."
    j:rt:par
    j:rt:rm "Copyright \251 1992-1995 by Jay Sekora.  "
    j:rt:rm "Terms for copying are specified in the documentation and "
    j:rt:rm "in comments in the code."
    j:rt:par
    j:rt:rm "If you find bugs or have suggestions for improvement, "
    j:rt:rm "please let me know.  "
    j:rt:rm "Feel free to use bits of this code in your own "
    j:rt:tt "wish"
    j:rt:rm " scripts."
  }]
  j:about .about $about_jdoc
  j:about:button .about {jdoc} $about_jdoc
  j:about:button .about {Author} [j:about_jay]
  j:about:button .about {Tk and Tcl} [j:about_tktcl]
  j:about:button .about {Donations} [j:about_donations]
  
  tkwait window .about
}

##############################################################################
# jdoc:cmd:doc_prefs - preferences panel
##############################################################################

j:command:register jdoc:cmd:doc_prefs {Doc Viewer Preferences...}
proc jdoc:cmd:doc_prefs { w args } {
  global JDOC_PREFS
  
  set old_focus [focus]			;# so we can restore original focus
  
  set w .doc_prefs
  toplevel $w
  wm title $w [j:ldb "Help Viewer Preferences"]

  frame $w.size
  label $w.size.wl -text [j:ldb {Width:}]
  entry $w.size.we -width 3 \
    -textvariable JDOC_PREFS(textwidth)
  label $w.size.hl -text [j:ldb {Height:}]
  entry $w.size.he -width 3 \
    -textvariable JDOC_PREFS(textheight)

  j:colour_chooser $w.textbg -variable JDOC_PREFS(textbg) \
    -label "Normal Background:"
  j:colour_chooser $w.textfg -variable JDOC_PREFS(textfg) \
    -label "Normal Foreground:"
  j:colour_chooser $w.textsb -variable JDOC_PREFS(textsb) \
    -label "Selected Background:"
  j:colour_chooser $w.textsf -variable JDOC_PREFS(textsf) \
    -label "Selected Foreground:"
  
  label $w.textsbw-label -text [j:ldb {Selection Border Width:}] -anchor w
  scale $w.textsbw -from 0 -to 25  -orient horizontal \
    -command {set JDOC_PREFS(textsbw)}
  $w.textsbw set $JDOC_PREFS(textsbw)
  
  label $w.textbw-label -text [j:ldb {Text Border Width:}] -anchor w
  scale $w.textbw -from 0 -to 50  -orient horizontal \
    -command {set JDOC_PREFS(textbw)}
  $w.textbw set $JDOC_PREFS(textbw)
  
  j:buttonbar $w.b -default save -buttons [format {
    { 
      save Save {
        jdoc:configure_text .t
        j:write_prefs -array JDOC_PREFS -file jdoc-defaults
        destroy %s
      }
    } {
      done Done {
        jdoc:configure_text .t
        destroy %s
      }
    }
  } $w $w]
  
  pack $w.size.wl $w.size.we [j:filler $w.size] $w.size.hl $w.size.he \
    -in $w.size -side left

  pack \
    $w.size \
    [j:rule $w] \
    $w.textbg \
    [j:rule $w] \
    $w.textfg \
    [j:rule $w] \
    $w.textsb \
    [j:rule $w] \
    $w.textsf \
    [j:rule $w] \
    $w.textsbw-label $w.textsbw \
    [j:filler $w] \
    $w.textbw-label $w.textbw \
    [j:rule $w] \
    $w.b \
    -in $w -side top -fill x

  j:dialogue $w		;# position in centre of screen

  focus $w
  j:default_button $w.b.save $w.size.we $w.size.he $w
  j:tab_ring $w.size.we $w.size.he
  bind $w <Key-Tab> "focus $w.size.we"
  tkwait window $w
  j:tk3 {focus $old_focus}
  j:tk4 {focus -force $old_focus}	;# can't figure out a better way...
}

##############################################################################
# jdoc:cmd:quit - quit
##############################################################################

j:command:register jdoc:cmd:quit {Quit}
proc jdoc:cmd:quit { w args } {
  if [j:confirm -text "Are you sure you want to quit?"] {
    exit 0
  }
}

##############################################################################
# jdoc:cmd:load - prompt user to select topic from a list
##############################################################################

j:command:register jdoc:cmd:load {Load...}
proc jdoc:cmd:load { w args } {
  global JDOC_PREFS JDOC_PATH JDOC_TOPIC
  
  if [winfo exists .topics] {destroy .topics}
  toplevel .topics
  label .topics.l -text [j:ldb "Double-click on a topic:"]
  listbox .topics.lb -relief flat \
    -yscroll {.topics.sb set} -exportselection false
  j:tk3 {.topics.lb configure -geometry 30x20}
  j:tk4 {.topics.lb configure -width 30 -height 20}
  scrollbar .topics.sb -command {.topics.lb yview}
  button .topics.ok -width 10 -text OK -command {
    set JDOC_TOPICS ""
    catch {
      set JDOC_TOPIC [.topics.lb get [lindex [.topics.lb curselection] 0]]
    }
    if [string length $JDOC_TOPIC] {
      destroy .topics
    } else {
      j:alert -text "You must click on a topic to select it."
    }
  }
  pack append .topics \
    .topics.ok {bottom pady 5 padx 5} \
    [j:rule .topics] {bottom fillx} \
    .topics.l {top fillx pady 10} \
    [j:rule .topics] {top fillx} \
    .topics.lb {left expand fill} \
    [j:rule .topics] {left filly} \
    .topics.sb {left filly}

  set topics {}
  
  foreach dir $JDOC_PATH {
    foreach file [glob -nocomplain $dir/*.jdoc] {
      set topic [file rootname [file tail $file]]
      if {[lsearch -exact $topics $topic] == -1} {
        lappend topics $topic
      }
    }
  }
  if {"x$topics" == "x"} {
    j:alert -text "Unable to find any help files."
    destroy .topics
    return
  }
  foreach topic [lsort $topics] {
    .topics.lb insert end $topic
  }
  bind .topics.lb <Double-Button-1> {
    set JDOC_TOPIC [.topics.lb get [lindex [.topics.lb curselection] 0]]
    destroy .topics
  }
  j:tk4 {
    bind .topics.lb <Double-Button-1> "+\nbreak\n"
  }
  j:dialogue .topics
  tkwait window .topics
  jdoc:load_topic $JDOC_TOPIC
}

######################################################################
# jdoc:cmd:save_as - save to a file
######################################################################

j:command:register jdoc:cmd:save_as {Save As...}
proc jdoc:cmd:save_as { w args } {
  j:tc:saveas $w
}

######################################################################
# jdoc:cmd:print_postscript - print rich-text as postscript using lpr
######################################################################

j:command:register jdoc:cmd:print_postscript {Print}
proc jdoc:cmd:print_postscript { w args } {
  global J_PREFS
  if [j:confirm -priority 24 \
    -text "Print as PostScript using `lpr' to printer `$J_PREFS(printer)'?"] {
    exec lpr -P$J_PREFS(printer) << [j:tc:ps:convert_text $w]
  }
}

######################################################################
# jdoc:cmd:find - search for a string in the document
######################################################################

j:command:register jdoc:cmd:find {Find...}
proc jdoc:cmd:find { w args } {
  j:find -replace 0 $w
}

######################################################################
# dummy to force loading of this file and registration of commands:
#
proc jdoc:register_commands {} {}
#
######################################################################


