######################################################################
######################################################################
### Fixed version of tkMenuButtonDown from Tk4.1a1 - fixes problems
### with grabs.  This is also fixed in Tk4.0p2.
######################################################################
######################################################################

This software is copyrighted by the Regents of the University of
California, Sun Microsystems, Inc., and other parties.  The following
terms apply to all files associated with the software unless explicitly
disclaimed in individual files.  [In the jstools distribution, it only
applies to this file (lib/jedit_fix_tkMenuButtonDown.tcl.]

The authors hereby grant permission to use, copy, modify, distribute,
and license this software and its documentation for any purpose, provided
that existing copyright notices are retained in all copies and that this
notice is included verbatim in any distributions. No written agreement,
license, or royalty fee is required for any of the authorized uses.
Modifications to this software may be copyrighted by their authors
and need not follow the licensing terms described here, provided that
the new terms are clearly indicated on the first page of each file where
they apply.

IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY
FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
ARISING OUT OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY
DERIVATIVES THEREOF, EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.

THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE
IS PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE
NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
MODIFICATIONS.

RESTRICTED RIGHTS: Use, duplication or disclosure by the government
is subject to the restrictions as set forth in subparagraph (c) (1) (ii)
of the Rights in Technical Data and Computer Software Clause as DFARS
252.227-7013 and FAR 52.227-19.

proc jedit:fix_tkMenuButtonDown {
  j:tk4 {
    global tk_patchLevel
    if {[info exists tk_patchLevel]} {
      if {$tk_patchLevel != "7.4p2"} {
        # Copyright (c) 1992-1994 The Regents of the University of California.
        # Copyright (c) 1994-1995 Sun Microsystems, Inc.
        # terms and disclaimer as specified in the file "license.terms"
        #   in the Tk4.1a1 distribution
        
        # tkMenuButtonDown --
        # Handles button presses in menus.  There are a couple of tricky things
        # here:
        # 1. Change the posted cascade entry (if any) to match the mouse
        #    position.
        # 2. If there is a posted menubutton, must grab to the menubutton;  this
        #    overrrides the implicit grab on button press, so that the menu
        #    button can track mouse motions over other menubuttons and change
        #    the posted menu.
        # 3. If there's no posted menubutton (e.g. because we're a torn-off menu
        #    or one of its descendants) must grab to the top-level menu so that
        #    we can track mouse motions across the entire menu hierarchy.
        #
        # Arguments:
        # menu -		The menu window.
        
        proc tkMenuButtonDown menu {
            global tkPriv
            $menu postcascade active
            if {$tkPriv(postedMb) != ""} {
                grab -global $tkPriv(postedMb)
            } else {
                while {[wm overrideredirect $menu]
                        && ([winfo class [winfo parent $menu]] == "Menu")
                        && [winfo ismapped [winfo parent $menu]]} {
                    set menu [winfo parent $menu]
                }
        
                # Don't update grab information if the grab window isn't
                # changing.  Otherwise, we'll get an error when we unpost
                # the menus and restore the grab, since the old grab
                # window will not be viewable anymore.
        
                if {$menu != [grab current $menu]} {
                    tkSaveGrabInfo $menu
                }
        
                # Must re-grab even if the grab window hasn't changed, in order
                # to release the implicit grab from the button press.
        
                grab -global $menu
            }
        }
      }
    }
  }
}
