proc mode:hook:init { t } {
  global JEDIT_MODEPREFS
  
  j:read_prefs -array JEDIT_MODEPREFS -prefix hook \
    -directory ~/.tk/jeditmodes -file hook-defaults {
    {textfont default}
    {textwidth 80}
    {textheight 30}
    {textwrap char}
    {sabbrev 0}
    {dabbrev 0}
    {autobreak 1}
    {autoindent 0}
    {savestate 0}
    {buttonbar 1}
    {buttons {
      jedit:cmd:done
      jedit:cmd:save
      jedit:cmd:load
      jedit:cmd:print
    }}
    {menu,editor 1}
    {menu,file 1}
    {menu,edit 1}
    {menu,prefs 1}
    {menu,abbrev 1}
    {menu,filter 1}
    {menu,format 0}
    {menu,display 1}
    {menu,mode1 1}
    {menu,mode2 1}
    {menu,user 1}
  }
  
  set toplevel [jedit:text_to_top $t]
  label $toplevel.blue -bg blue -fg white -bd 2 -relief raised \
    -text {hook mode test}
  pack $toplevel.blue -fill both
}

proc mode:hook:cleanup { t } {
  set toplevel [jedit:text_to_top $t]
  destroy $toplevel.blue
}

### proc mode:hook:pre_returnkey_hook t {
###   $t insert insert { [CR]}
### }
### 
### proc mode:hook:post_returnkey_hook t {
###   $t tag add sel {insert -1 line linestart} {insert -1 line lineend}
### }
### 
### proc mode:hook:pre_tabkey_hook t {
###   $t tag add sel {insert -1 char wordstart}
### }
### 
### proc mode:hook:post_tabkey_hook t {
###   $t tag remove sel {insert -1 char}
### }
### 
### proc mode:hook:pre_spacebar_hook t {
###   $t tag add sel {insert -1 char wordstart} {insert}
### }
### 
### proc mode:hook:post_spacebar_hook t {
###   $t tag remove sel {insert -1 char}
### }

### proc mode:hook:spacebar t {
###   jedit:sabbrev_hook $t
###   j:tb:insert_nondigit "\\ " $t
###   jedit:autobreak_hook $t
### }
### 
### proc mode:hook:returnkey t {
###   j:tb:insert_nondigit "\\\n" $t
### }
### 
### proc mode:hook:tabkey t {
###   j:tb:insert_nondigit {^I} $t
### }

proc mode:hook:post_returnkey_hook t {
  $t tag configure proc-start -foreground red \
    -font "-*-lucidatypewriter-bold-r-normal-sans-18-*-*-*-*-*-*-*"
  set line [$t get {insert -1 line linestart} {insert -1 line lineend}]
  if [string match {proc *\{} $line] {
    $t tag add proc-start {insert -1 line linestart} {insert -1 line lineend}
  }
}

proc mode:hook:pre_quit_hook t {
  j:alert -text {Oh, sure, just quit and leave me all by myself!}
}

proc mode:hook:quit t {
  if [j:confirm -priority 100 \
    -text "tes vous sr(e)?" \
    -yesbutton Oui -nobutton Non] {
    if [j:confirm -priority 100 \
      -text "tes vous vraiment sr(e)?" \
      -yesbutton Oui -nobutton Non] {
      exit 0
    }
  }
}

proc mode:hook:done t {
  if [j:confirm -priority 100 \
    -text "Are you COMPLETELY sure you're done?"\
    -yesbutton Yuppers -nobutton Nope] {
    jedit:cmd:save $t
    jedit:cmd:quit $t
  } else {
    j:alert -text "Saving..."
    jedit:cmd:save $t
  }
}
