#
# artdialog.tcl
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

#
# ArticleDialog
#
# Public attributes:
#   -closecommand	command when quit is selected
#   -title		title
#
# Methods:
#
itcl_class ArticleDialog \
{
  constructor {config} \
  {
    #
    #  Create a window with the same name as this object
    #
    set class [$this info class]
    ::rename $this $this-tmp-
    ::toplevel $this -class $class
    ::rename $this $this-win-
    ::rename $this-tmp- $this
    wm title $this $title

    ArticleWindow $this.article -main $main
    pack $this.article -expand yes -side top -fill both
 
    frame $this.buttons -relief sunken -bd 1
    button $this.buttons.save -text "Save.." -width 8 \
		-command "$this save"
    button $this.buttons.followup -text "Followup.." -width 8 \
		-command "$this followup"
    button $this.buttons.close -text "Close" -width 8 \
		-command "$this close"
    pack $this.buttons.save $this.buttons.followup -side left \
		-padx 3 -pady 2
    pack $this.buttons.close -side right -padx 3 -pady 2
    pack $this.buttons -side top -fill x

    wm protocol . WM_DELETE_WINDOW "$this close"
  }

  destructor \
  { ::rename $this-win- {} }

  method config {config} {}

  method save {} \
  { if {$file_dialog == ""} \
    { set file_dialog [FileSelect $this.file_dialog \
		-title "Article - Save"]
    } \
    else \
    { wm deiconify $file_dialog }

    if {[$this.file_dialog activate]} \
    { set filename [$this.file_dialog get]
      set article [$this.article.text get 1.0 end]
      set fp [open $filename w]
      puts -nonewline $fp $article
      ::close $fp
    }

    wm withdraw $file_dialog
 }

  method followup {} \
  { if [info exists header_field(Subject)]\
    { set subject $header_field(Subject)
      if {[string first "Re:" $subject] == -1} \
      { set subject "Re: $subject" }
    } \
    else \
    { set subject "" }
    if [info exists header_field(Message-ID)]\
    { set references $header_field(Message-ID) } \
    else \
    { set references "" }
    if {$article_list != ""} \
    { $article_list followup $subject $references }
  }

  method close {} \
  { eval $closecommand }

  method showArticle {group_name article_number} \
  { wm title $this "$title - $group_name"
    catch {unset header_field}
    set header_field(From) ""
    set header_field(Subject) ""
    set header_field(Newsgroup) $group_name
    set header_field(Organization) ""
    set header_field(References) ""
    set nntp_socket [$main getNntpSocket]
    if {$nntp_socket != ""} \
    { # dp_send $nntp_socket "group $current_group"
      # gets $nntp_socket line
      set article_text {}
      $this.article clearAll
      dp_send $nntp_socket "article $article_number"
      gets $nntp_socket line
      if {[lindex $line 0] != "220"} \
      { show_error $this [string range [string trimright $line] 4 end ]
      } \
      else \
      { set done 0
        set header_done 0
        while {$done == 0} \
        { gets $nntp_socket line
          set line [string trimright $line]
          if {$line == ""} \
          { set header_done 1 }
          if {$line == "."} \
          { set done 1 } \
          else \
          { if {$header_done == 0} \
            { set fields [split $line :]
              set field [string trim [lindex $fields 0]]
              set value [string trim [lindex $fields 1]]
              set header_field($field) $value
            } \
            else \
            { append article_text "$line"
              append article_text "\n"
            }
          }
        }
        $this.article setArticleBody $article_text
        $this.article setHeaders $header_field(Newsgroup) \
		$header_field(From) $header_field(Subject) \
		$header_field(Organization) $header_field(References)
      }
    }
  }

  method takeFocus {} \
  {
  }

  public closecommand ""
  public main ""
  public article_list ""
  public title ""

  protected current_group ""
  protected article_numbers
  protected article_dialog ""
  protected file_dialog ""
  protected header_field
}




