#
# Tcl/Tk based news reader
#
# Copyright 1995 - Koert Zeilstra
#
# No warranty - use at your own risk
#

#
# GroupStat
#
# Public attributes:
#
# Methods:
#
itcl_class GroupStat \
{
  constructor {config} \
  {
  }

  destructor \
  { }

  method config {config} {}

  method reset {} \
  { set read_articles ""
    unset read_articles
  }

  method load {filename} \
  { set fp [open $filename r]
    set line ""
    while {[gets $fp line] >= 0} \
    { set name ""
      if [regexp "\.+:" $line] \
      {
        if [regexp "(\[0-9,a-z,A-Z,\.\]+): *(.*)" $line m name art] \
        { set read_articles($group) [split $artlist ","] }
      }
    }
    close $fp
    set is_changed 0
  }

  method save {filename} \
  { set fp [::open $filename w]
    set groups [lsort [array names read_articles]]
    foreach group $groups \
    { puts $fp "${group}: [join $read_articles($group) ","]" }
    ::close $fp
    set is_changed 0
  }

  method deleteGroup {group} \
  { unset read_articles($group)
    set is_changed 1
 }

  method addGroup {group} \
  { set read_articles($group) {} }

  method setGroupReadArticles {group artlist} \
  { set read_articles($group) [split $artlist ","] }

  method updateGroupReadArticles {group artlist} \
  { set read_articles($group) $artlist
    set is_changed 1
  }

  method getGroupReadArticles {group} \
  { if [info exists read_articles($group)] \
    { return $read_articles($group) } \
    else \
    { return {} }
  }

  method isRead {group article} \
  { set found 0
    if [info exists $read_articles($group)] \
    { foreach artlist $read_articles \
      { set alist [split $artlist -]
        if {[llength $alist] == 1} \
        { if {$alist == $article} \
          { set found 1; break }
        } \
        else \
        { if {$article >= [lindex $alist 0] || $article <= [lindex $alist 1]} \
          { set found 1; break }
        }
      }
    }
    return $found
  }

  method getLast {group} \
  { if [info exists read_articles($group)] \
    { set art [lindex $read_articles($group) end]
      set alist [split $art -]
      set number [lindex $alist end]
    } \
    else \
    { set number 1 }
    return $number
  }

  method isChanged {} \
  { return $is_changed }

  method addArticle {group number} \
  { set read_articles($group) [list "1-$number"] }

  method setGroupReadArticlesOld {group artlist} \
  { set read_articles($group) {}
    foreach art [split $artlist ","] \
    { lappend read_articles($group) [split $art "-"] }
  }

  method isReadOld {group article} \
  { if [info exists $read_articles($group)] \
    { foreach artlist $read_articles \
      {
      }
    }
  }

  protected read_articles
  protected group_stat
  protected is_changed 0
}

itcl_class ArticleList \
{
  constructor {config} \
  {
  }

  destructor \
  { }

  method setArticleList {list} \
  { catch {unset article_array}
    set length [llength $list]
    if {$length == 0} \
    { set lowest_number 1 } \
    else \
    { set first_art [lindex $list 0]
      if {[string first "-" $first_art] < 0} \
      { set lowest_number $first_art } \
      else \
      { set lowest_number [lindex [split $first_art "-"] 1] }

      if {$length > 1} \
      { set numbers [lrange $list 1 end]
        foreach art $numbers \
        {
          if {[string first "-" $art] >= 0} \
          { set art [split $art "-"]
            set art1 [lindex $art 0]
            set art2 [lindex $art 1]
            for {set i $art1} {$i < $art2} {incr i} \
            { set article_array($i) 1 }
          } \
          else \
          { set article_array($art) 1 }
        }
      }
    }
  }

  method getArticleList {} \
  { set result {}
    set numbers [lsort -integer [array names article_array]]
    set length [llength $numbers]
    if {$length == 0} \
    { if {$lowest_number > 1} \
      { set result "1-$lowest_number" }
    } \
    else \
    { if {$length == 1} \
      { set result [list "1-[lindex $numbers 0]"] } \
      else \
      { if {$lowest_number == 1} \
        { set lowest_number [lindex $numbers 0]
          set numbers [lrange 1 end $numbers]
        }
        set start 1
        set previous_number $lowest_number
        foreach number $numbers \
        { if {$previous_number != 1 && $previous_number != [expr $number-1]} \
          { if {$start == $previous_number} \
            { lappend result "$start" } \
            else \
            { lappend result "$start-$previous_number" }
            set start $number
          }
          set previous_number $number
        }
      }
    }
puts "art list: $result"
    return $result
  }

  method getLowestNumber {} \
  { return $lowest_number }

  method setLowestNumber {number} \
  { set lowest_number $number }

  method isRead {number} \
  { if {$number <= $lowest_number} \
    { return 1 }
    if [info exists article_array($number)] \
    { return $article_array($number) } \
    else \
    { return 0 }
  }

  method setRead {number} \
  { set article_array($number) 1 }

  method setReadAll {number} \
  { set lowest_number $number
    catch {unset article_array}
  }

  method setNotRead {number} \
  { catch {unset article_array($number)} }

  protected lowest_number 1
  protected article_array
}








