.TH PT 1 "13 Jan 1994"
.SH NAME
Point \- an X-based text editor
.SH SYNOPSIS
.B point
[-nobrowser] [-nb]
[
.IR filename \.\|\.\|\.\|]

.B pt
[-create] [-c]
[-wait] [-w]
[-DIGIT]
[-interp interpName]
[
.IR filename \.\|\.\|\.\|]
.SH DESCRIPTION
This document gives an overview of Point so you can
get started using it quickly to determine whether you like it or not.
There is a longer manual that describes Point in detail.
Point is highly configurable but in this document will describe
the configuration specified in files \fItclLib/*.tcl\fR.



.SH PT USAGE

When the \fIpoint\fR executable file is called with the name \fIpt\fR
it acts like \fIpt\fR which is described in this section.
The purpose of \fIpt\fR is to send file names to \fIpoint\fR
to open a window on.
It does this by sending a message to \fIpoint\fR through the X server.

A window will be opened on each of the files specified in the command.
Since file name wildcards are handled by the shell they can be used
with the \fIpt\fR command also.

Normally, when \fIpoint\fR is asked to open a file that does not exist it
asks the user (through a dialogue box) if it should create the file.
The \fI-create\fR (or \fI-c\fR) option suppresses the dialogue box
and creates the file without asking.

Normally, \fIpt\fR will send the message to \fIpoint\fR to open the files
and then \fIpt\fR will exit.
The \fI-wait\fR (or \fI-w\fR) option causes \fIpt\fR to wait until each
of the files it asked \fIpoint\fR to open have been closed.

The purpose of these two options is to support using \fIpoint\fR as the
editor that is called as a subprocess by programs that need to allow
the user to edit a file.
The most common example of this is a mail program that drops you
into the editor of your choice to compose the message.
Since \fIpoint\fR generally runs all the time, you can use \fIpt\fR as the
"editor" in these cases.
When you use \fIpt\fR like this you want it to wait around until the
message has been composed and the file closed.
In addition the file is generally a temporary file whose name
is generated by the program calling the editor.
In this case you do not want \fIpoint\fR to ask the user if she or he
wants to create this file will this odd sounding name like
\fI/tmp/snd.2346\fR so you use the \fI-create\fR option to prevent this.

The \fI-interp\fR option is used if you rename the \fIpoint\fR executable to
some name other than "\fIpoint\fR".

Windows are normally placed at the default location in the upper
left corner of the screen.
This corresponds to \fIlocation1\fR set in \fIptsetup.tcl\fR.
If you want \fIpoint\fR to open up the windows in different locations
you can use the \fI-DIGIT\fR option to \fIpt\fR.
This causes the following windows to be opened at location
\fIlocationDIGIT\fR.
You can have any number of \fI-DIGIT\fR options in the \fIpt\fR command line.
Each one applies to all windows created until the next \fI-DIGIT\fR
option is found.



.SH POINT USAGE


.SS Starting Point
You just have to make sure that
.I point
is in your
.IR path .
Point uses a startup file to specify menus, key bindings and options.
Point will look for a startup file
.I ~/.ptrc
first.
Typically this will just source the real startup file but by doing it
this way, the startup file is found no matter which directory you
start \fIpoint\fR in.
If it cannot find that it will look for 
.IR ./ptsetup.tcl .
If it cannot find either of those it will use an installation
default which is the configuration described in this manual page.
The default startup file will print out its pathname so you can
copy and modify it to configure Point the way you would like.
.LP
When Point starts a
.I file browser
appears in the upper, central part
of your screen and a text window for each file name on the command line
will appear on the upper left, all stacked on top of each other
(thus you will only see one text window).

.SS Selecting text
The
.I selection
is a central concept in Point.
The selection is the implied object of many Point commands
(e.g., delete, move, copy, search).
The
.I insertion point
is the position just in front
of the first character of the selection and is the destination
of all insert operations in Point (e.g., typed characters, insert scrap,
move and copy)
The selection is one or more characters of text in one of the
files shown in the open text windows.
There is only one selection among all the text windows at any one time.
.LP
You select text in the usual way, that is,
you move the sprite to the first character of the intended
selection, press the left mouse button, move the sprite to
the last character of the selection and release the left mouse button.
Alternatively you can click the left mouse button on the
first character of the intended selection and click the right
mouse button on the last character of the selection.
Finally you can double (triple) click on a word (line) to select it.
By holding down the second (third) click and moving the mouse
you can extend the selection by words (lines).


.SS X selections
When you select text in Point it becomes the X selection
and can be inserted in \fIxterm\fR windows (for example) by clicking
the middle mouse button.
The ``Insert X selection'' command (on the EDIT menu) inserts the X selection
into a Point text window at the insertion point. 
This X selection must be made after any Point selections to ensure
that it is the current X selection.


.SS Editing text
Typed characters are inserted at the insertion point
(just in front of the first character of the selection).
The delete (to the scrap buffer) command
deletes the selected text into the scrap buffer.
The delete command is on the \fIScrap =>\fR submenu of the EDIT menu
and is also bound to the F1 key.
The insert (from the scrap buffer) command inserts the text
in the scrap buffer at the insertion point.
The insert command is on the \fIScrap =>\fR submenu of the EDIT menu
and is also bound to the F2 key.
.LP
Point keeps a history list of all commands executed.
The \fIagain\fR command repeats the last command using the current selection.
The \fIundo\fR command undoes the last command.
Additional \fIundo\fR commands undo earlier and earlier commands.
If you undo too many commands the \fIredo\fR command will
redo an undone command.
These are all on the \fIUndo/Again/Redo =>\fR submenu of the EDIT menu
and on the \fI+Do-\fR button on the text window menu bar.


.SS Scrolling the text
Point has vertical and horizontal scroll bars.
The size and position of the slider in the scroll bar indicate how
much of and what part of the file is being displayed in the window.
The right mouse button scrolls down (towards the end of the file)
and the left mouse button scrolls up (towards the beginning of the file)
when they are clicked in the scroll bar.
The line of text beside the sprite (mouse cursor) is moved to the top
of the window when you scroll down and is replaced by the top
line when you scroll up.
This allows you to control exactly the number of lines scrolled.
It is common to use this feature to move the beginning of the text
of interest (say a procedure definition) to the top of the window.
If you hold down the left or right mouse button the window
will scroll continuously (after a short initial delay).
When the middle mouse button is clicked in the scroll bar the window
jumps so that the top of the slider is located at the location of
the mouse sprite.
The middle mouse button can also be dragged to scroll the text.


.SS Searching for text
The \fISearch for string =>\fR submenu of the GOTO menu contains
several commands
which search for a string and reposition the window
so that the string is displayed in the window.
You can search forward (backward) for the next (previous) instance of the
selected text.
You can also repeat the last search (forward or backwards),
that is, search again for the last string searched for or
you can bring up a dialogue box that allows you to enter a search string.
Also there is a regular expression search command that uses the same
types of regular expressions as the Unix commands grep/sed/ed/ex/vi.


.SS Moving around the file
The GOTO menu contains several other functions that move the window
around the text.
The \fIMove in file to =>\fR submenu has specific commands to move
to the beginning and end of the
file although this can also be done using the scroll bar.
When you jump around the file (that is, any movement not a scroll)
Point remembers the last place you jumped from
and there is a command to go back to that place.
This command is convenient for alternating between two places
in the file.
The GOTO menu also has commands to go to specified line
numbers and to show the selection.


.SS Moving and resizing windows
The FILE menu has a submenu (\fIMove Window =>\fR) with four commands
(\fIMove to (NW,NE,SE,SW)\fR)
which will move windows to one of the predefined
locations for windows and a \fIZoom vertical\fR command that
zooms the window vertically to (almost) the whole height of the screen.
You can also move and resize the windows using the usual
window manager commands.


.SS Raising and lowering windows
Click on a window name in the list of windows at the top of the
file browser to top that window (and move it to
the first predefined window stack location).
Clicking with the middle or right mouse buttons tops the window and
moves it to the second or third window stack locations.
You can also raise and lower windows using the window manager.


.SS Opening windows and changing directories
To open a window, double click on the name of the desired
file in the file browser.
To change to a directory, double click on its name in the file browser.
The DIRS menu (on the file browser menu bar)
also allows direct jumps to some directories.
Double clicking with the middle or right mouse buttons
also opens a window but at the second (SE)
and third (NE) window stack locations.


.SS Closing windows
To close a window, click on the \fIClose\fR item on its menu bar.
If the file in the window has been edited and not saved it will be
saved automatically (click with the right mouse button to prevent
this saving).
The \fIClose =>\fR submenu of the FILE menu has commands
to close and automatically save and close and automatically not save.
You can also save the file or write it to a new name
using commands from the FILE menu.


.SS Redrawing the screen
Point occasionally fails to update the display correctly.
Clicking the right mouse button on \fISv\fR and selecting
the \fIRedraw window\fR command
on the EDIT menu) fixes it up and ensures that the
display reflects the actual state of the text.


.SS Changing fonts
The FILE menu (submenu \fISet text fonts =>\fR)
allows you to change the font used to display the
text in the window.
This allows you to see more text or see it the text more easily
(but not both).
You can change the font size at any time.
It is often useful to change to a smaller font for a short time
in order to see more text.


.SS The text window menu bar
The FILE menu contains file and window related commands.
The EDIT menu contains commands that change text.
The GOTO window contains commands that move the window around the text
(including the search commands).

Most of the menu bar items do different things depending
on which mouse button you click on them.
I have tried to group the functions logically with related
functions grouped together.
Here are the overloaded functions (where LMB represents
clicking the left mouse
button and MMB and RMB clicking the middle and right mouse buttons):
.LP
.IP \fB<<\fR
LMB: search backward for selection, MMB: pop up search dialogue box,
RMB: search backward for the last string searched for
.IP \fB>>\fR
LMB: search forward for selection, MMB: pop up search dialogue box,
RMB: search forward for the last string searched for
.IP \fBClose\fR
LMB: close and save, MMB: close and ask about saving changes,
RMB: close and do not save changes
.IP \fBSv\fR
LMB: save, MMB: save as (write with new name), RMB: redraw the window
(This combination is not logical but I wanted redraw somewhere.)
.IP \fBJump\fR
LMB: beginning of file, MMB: last place jumped from, RMB: end of file
.IP \fBTag\fR
LMB: find selected tag,
MMB: bring up tag dialogue box
RMB: find selected keyword
.IP \fB+Do-\fR
LMB: redo, MMB: repeat last edit (again), RMB: undo
.IP \fBZz\fR
LMB: make selection upper case, MMB: toggle case of selection,
RMB: make selection lower case
.IP \fBMoveW\fR Move this window to:
LMB: NW position, MMB: SE position, RMB: NE position
.IP \fBLine#\fR
LMB: got selected line number, MMB: pop up goto line number dialogue box,
RMB: zoom window vertically
(This combination is not logical but I wanted zoom vertical somewhere.)


.SS Typing in a line number
It can be inconvenient to wait for the dialogue box to come up to type
in a line number.
One solution is to select it and goto the selected line number.
This function works with the X selection as well as the Point selection
(whichever one was made more recently)
so the line number can be compiler output in an \fIxterm\fR window.
Another solution is to just type digits into the \fILine#\fR menu bar
item, that is, move the mouse cursor into \fILine#\fR and type
(no mouse button press or click is required).
End the number with any non-digit character (I usually use a function
key since it is close to the digits on my keyboard).


.SS Typing in incremental search strings
You can search for the X selection in a window to avoid retyping
the search string.
That is, you can select a string in any X window that support
X selections and then search for it in any Point window with the
\fI<<\fR or \fI>>\fR buttons or using a mouse menu to invoke the search for
selection command.
You can also type the search string directly into
the \fI<<\fR or \fI>>\fR menu bar buttons,
that is, (as above) move the sprite inside \fI<<\fR or \fI>>\fR and type.
You can also begin an incremental search with control-s.
This form of search is incremental, that is, Point searches after each
character is added to the search string.
Any non-ASCII character restarts the search string (I use a function key).
(It is useful to get in the habit of hitting a function key first to
clear the search string since it keeps accumulating otherwise.
The ``\fIyourString\fR not found'' error message will remind you
if you forget.)
The incremental search is convenient since you only have to type
a unique prefix of the desired string.


.SS C tags
Point supports the ``tags'' facility like \fIvi\fR and \fIemacs\fR.
Just create a tags file in the normal way with ctags.
You can find a selected tag or type the tag in a dialogue box.
Both commands are on GOTO menu.
The file the tag is in is loaded into a new window
(unless it is already in a window in which case the window is raised)
and jumped to the location of the tag.


.SS Keyword search 
I commonly want to see all the places a variable name is used in
my program.
Grep can be used for this and Point's keyword search facility
will call grep for you.
The keyword can be the selection or can be typed into a dialogue box
(both commands are on the GOTO menu).
They both bring up a dialogue box with a list of the
files that contain that keyword.
If you click (once) on a file name in the list a window
is opened on the file (or the window is topped if the file is already
in an open window),
the window is jumped to the first instance of the keyword,
the keyword is selected and an asterisk is placed before the
file name on the list so you can easily tell which files
you have already examined and which you haven't.


.SS Function keys
.IP
.B Arrow keys
move the selection up, down, left and right
.IP
.B F1
delete the selection to the scrap buffer
.IP
.B F2
insert text in the scrap buffer at the insertion point
.IP
.B F3
search backwards from the selection for the last string searched for
.IP
.B F4
search forwards from the selection for the last string searched for
.IP
.B F5
repeat the last edit (using the current selection and insertion point)
.IP
.B F6
redo the last undone edit
.IP
.B F7
scroll up one page
.IP
.B F8
scroll down one page
.IP
.B F9
undo the last edit (this is undoable with redo)
.LP
The best use of function keys is to combine with mouse commands to
get maximum editing bandwidth.
For example I usually select things with the mouse and execute
delete (F1), insert (F2) or again (F5) commands with function keys.
I also often use repeat search (F4) and repeat edit (F5) alternatively
to do an interactive search and replace.


.SS The browser window
The browser window contains:
.HP
\(bu two arrows which change the size of the list of open windows,
.HP
\(bu A list of open text windows \(em click on a name to top and
relocate the window \- the mouse button clicked determines the
new location: left button for NorthWest, middle button for SouthEast
and right button for NorthEast
.HP
\(bu A short menu bar of commands (see below),
.HP
\(bu A display of file and directory names.
Directories are shown with a ``/'' appended to their name.
If you double click on a directory name with the left mouse button
the browser switches to that directory.
If you double click on a directory name with the middle (right)
mouse button, a new browser is created in the second (third)
standard position and the new browser will display the named directory.
It is handy to have two or three file browsers on different
directories available at one time.
If you double click on a file name point will open a window on that file.
The button used determines the location of the new window:
left button for NorthWest, middle button for SouthEast
and right button for NorthEast.
.LP
The ``DIRS'' menu allows you to jump directly to one of
a list of preselected directories.
It also includes a command to change to the directory named by the
X selection.
.LP
The ``New Browser'' button creates new browsers.
The button determines which of three predefined browser positions
is used.
The initial browser is in the position  used when you click
on ``New Browser'' with the left mouse button.
The other two positions are to the right of that.
.LP
The ``MENU'' menu contains most of the commands in submenus.
The ``PREFS'' menu allows you to change most Point options.
It has several submenus and many check boxes and radio buttons.
The ``New Window'' button creates a new window and loads it with
the file name that is selected
(this can be either the Point selection or the X selection \(em whichever
one was made most recently).
The ``DIRS'' menu allows you to jump directly to one of
a list of preselected directories.

The MISC menu contains a number of occasionally useful commands.
It allows you to change the font used to display file names
in the browser.

The ``  *  '' button rereads and redisplays the directory contents.
The ``New Browser'' button creates another file browser.
The ``Del File'' button deletes the  file whose name is selected.
The ``Close'' button closes this file browser.
The ``QUIT'' menu exits Point and gives you three options for
the disposition of unsaved edits.


.SS Mouse menus
Pressing the middle or right mouse button enters a mode where you select
a command from a ``circular menu''.
When you press the middle or right mouse button, after a delay of 0.6 seconds,
the menu comes up showing the commands in each of five positions.
As you move the mouse around the circle you select the nearest command.
Release the button to execute the command.
To cancel the command click the left mouse button
and then release the mouse button.
The purpose of the delay is to allow you to give these
command without the overhead of displaying the menu.
If you select the direction and release the middle mouse button before
0.6 seconds is up the menu is not displayed.
.LP
The commands are for the \fBMiddle mouse button\fR:
.HP
\fBClose to it:\fR duplicate (copy-to-from)
.HP
\fBNorth (or up) of it:\fR delete the selection to the scrap buffer
.HP
\fBSouth (or down) of it:\fR insert the scrap buffer
.HP
\fBEast (or right) of it:\fR copy the selection to the location where
you first pressed the middle mouse button
.HP
\fBWest (or left) of it:\fR move the selection to the location where
you first pressed the middle mouse button
.LP
The commands are for the \fBRight mouse button\fR:
.HP
\fBClose to it:\fR extend the selection to this point
.HP
\fBNorth (or up) of it:\fR search towards the beginning of the file
.HP
\fBSouth (or down) of it:\fR search towards the end of the file
.HP
\fBEast (or right) of it:\fR undo the last edit
.HP
\fBWest (or left) of it:\fR repeat the last edit with the current selection


.SS Using mouse menus
The mouse menu commands are close at hand and are used for the
most common actions.
(Since this changes from user to user you will probably want to
change some of these commands on the mouse menus after you get used
to using Point.
The next section discusses customizing Point to your own tastes.)
The forward and backward searches are obviously useful to find
the previous and next use of a variable name in a program.
The duplicate command is for duplicating text.
Duplicating a line is the most common case:
.IP
1. Select the line (triple click) or lines (triple click and drag
before releasing the third click).
.IP
2. Duplicate the line(s) (double click the middle mouse button).
(Duplicate is the ``close to'' command so a fast click executes duplicate.
The first click sets the destination of the duplicate at the beginning
of the selected line and the second click copies the selected text to that
point.)
.LP
Another common use of duplicate is to copy a nearby word to the insertion
point as you are typing a line.
Suppose you are typing a line and you want to use a word that is
on a nearby line:
.IP
1. Stop typing where the word is to go and click the middle mouse button.
This executes duplicate which remembers the current insertion point.
.IP
2. Move the sprite to the word to be copied and select it
(with a double click).
.IP
3. Click the middle mouse button to execute duplicate a second time
which copies the selected word back to the line you were typing and
leaves the insertion point just after the copied word so you can
immediately resume typing the rest of the line.
.LP
I have found that any word longer that seven or eight characters is
worth copying rather than typing, especially in programs where misspelled
identifiers cause you to have to recompile.
Similarly to replace a word with a nearby word:
.IP
1. Select the word (double click)
.IP
2. Delete it (F1 or EDIT menu)
.IP
3. Duplicate (click middle button)
.IP
4. Select word to copy in (double click)
.IP
5. Duplicate (click middle button)
.LP
These techniques can be used repeatedly to build up or modify
lines from pieces of nearby lines.
Also the text to be copied need not be nearby text.
It can be in another window or in a different place in the same window.
Between the first and second duplicate commands you can invoke any other
Point commands.
For example, you can scroll windows, you can open new windows,
you can search in windows, etc.
.LP
The duplicate command mentioned above is a ``copy-to-from'' command
because first you give the location to copy to and then you select
the text to be copied there.
The East (left) mouse motion command is a ``copy-from-to'' command.
Here is how you would use it:
.IP
1. Select the text to be copied (the `from' text))
.IP
2. Move the mouse to the `to' point.
If you are copying a whole word (that is, if it was selected in
word mode \(em with a double click) then you can point anywhere
within the word and the text will be copied in front of that word.
Similarly, to copy text selected in line mode (triple click) you
can point anywhere in the line you want it copied in front of.
.IP
3. Press the middle mouse button and move to the left 
and then release the middle mouse button.
.LP
The Move scenario is nearly identical \- just move right in step 3.


.SS Moving windows
The ``MoveW'' menu item is useful for positioning windows quickly.
If I want to see two windows at the same time I usually put them in the
NW (left mouse button) and NE (right mouse button) window positions.
You can click the left (right) mouse button on either the ``MoveW''
menu item or on the window's file name in the main browser window.
A third document goes to the SE (middle mouse button) window position.
I find that I spend a lot of time looking at several files
at the same time during program development.


.SS Backups
Most UNIX users (except emacs users) are not used to backup files.
I got to like them using PCs even though at first I hated them
because they cluttered up my directory.
There are two options that control backups.
The first is ``backupDepth'' which determines how many versions
of each file are kept.
It can vary from 0 (no backups are kept) to 9
(the default is 1 but I use 6).
The backup files are often named with the file name appended with a period
and a digit (``.1'' to ``.9'' with ``.1'' being the most recent).
The option \fIbackupNameFormat\fR determines the form of
the name of the backup file and hence where the backup files are stored.
The default is the current directory (\fIbackupNameFormat=%n.%v\fR).
I use
.I backupNameFormat=bak/%n.%v
so the backup files are out of the way but there when I need them.
The backup file name can be a relative or absolute pathname.


.SS Hints for using Point
Section 7 of the Point Reference Manual has a number of hints on
how to use Point's features.
All of the command bindings described in this document are configurable
in by editing
.I ptsetup.tcl
(the Point configuration file).
You can look in this file but to change very much you should read the
relevant sections in the user's manual
.LP
You can change almost all of Point's options dynamically the
.I PREFS
menu.


.SH BUGS
See the file KnownBugs.


.SH AUTHOR
Charles Crowley
.br
Computer Science Department
.br
University of New Mexico
.br
Albuquerque, New Mexico 87131
.br
505-277-5446 (office) or 505-277-3112 (messages)
.br
crowley@cs.unm.edu



