' $Id: dbcontinue.n,v 1.2 1995/07/10 21:39:27 jfontain Exp $
.TH dbcontinue tcl
.BS
.SH NAME
dbcontinue \- retrieve a row with a SQL cursor
.SH SYNOPSIS
\fBdbcontinue \fIcursor ?debugLevel?\fR
.SH DESCRIPTION
.PP
A table row is returned for the specified \fIcursor\fR, which must be the return value of a prior \fBdbcursor\fR command. Each \fBdbcontinue\fR call sequentially returns a row in the form of a Tcl list. Each list element is a column value, in the order specified in the \fBdbcursor\fR command \fISELECT\fR statement.
.PP
If there are no more rows in the table, an empty list is returned and the \fIcursor\fR automatically freed (see the \fBdbfree\fR command). If the end of the table is not reached, the cursor must be freed using the \fBdbfree\fR command.
.PP
An error occurs if the \fIcursor\fR is invalid, or was already freed.
.PP
The debug level can optionally be set for this transaction (see \fBdbdebug\fR manual page).
.SH EXAMPLES
.PP
Print ids and names for all employees:
.sp
.RS
.nf
set cursor [\fBdbcursor \fI"select id, name from employees"\fR]
while {[llength [set row [\fBdbcontinue\fR $cursor]]]>0} {
    puts "id: [lindex $row 0], name: [lindex $row 1]"
}
.fi
.RE
.PP
Print the name of the first employee:
.sp
.RS
.nf
set cursor [\fBdbcursor \fI"select name from employees where id = 1"\fR]
puts "first employee: [lindex [\fBdbcontinue\fR $cursor] 0]"
\fBdbfree\fI $cursor
.fi
.RE
.SH KEYWORDS
.PP
dbcontinue, dbcursor, dbfree, dbdebug, SQL, jdb, shql

