#!/usr/local/bin/wish4.0
#
# NOTE: THIS IS STOLEN FROM TKINSPECT'S INSTALL SCRIPT!!!!
#  Thanks Sam Shen!

# Installation script for tkgoodstuff release 0.1.  To install:
#
# 1. Go to the tkgoodstuff source directory.
# 2. Type: wish -f install.tcl.
# 3. Fill out the form.
# 4. Hit the install button.  If all goes well, the last line in
#    the log window should be "Installed finished."
#

set tkgoodstuff_library .

label .title -text "tkgoodstuff Installation" \
    -font -adobe-helvetica-bold-r-*-*-*-180-*-*-*-*-*-*
pack .title -side top

text .instructions -relief ridge -bd 4 -width 20 -height 6 -wrap word \
-takefocus 0

.instructions insert 1.0 \
{Fill out the pathnames below and press the install button.  Any\
errors will appear in log window below.  If you wish to demo tkgoodstuff\
w/o installing it, try "wish4.0 tkgoodstuff".  The only actions\
this installation will perform are the creation of the library directory,\
placement of files in it, and the placement of the executables\
tkgoodstuff and Dialer in the bin directory.\
}
pack .instructions -side top -fill both -expand 1
set prefix /usr/local
set bindir $prefix/bin

frame .bindir
label .bindir.label -text "Bin dir:"
entry .bindir.entry -textvariable bindir
pack .bindir.label -side left
pack .bindir.entry -side right -fill x -expand yes

set libdir $prefix/lib/tkgoodstuff
frame .libdir
label .libdir.label -text "Library dir:"
entry .libdir.entry -textvariable libdir
pack .libdir.label -side left
pack .libdir.entry -side right -fill x -expand yes

frame .wish
label .wish.label -text "Wish executable:"
entry .wish.entry -textvariable wish
pack .wish.label -side left
pack .wish.entry -side right -fill x -expand yes
pack .wish

#install_exec .wish -label "Wish executable:" -variable wish
pack .bindir .libdir .wish -side top -fill x

text .log -width 70 -height 10 -bd 4 -relief ridge -takefocus 0
pack .log -side top -fill both -expand 1

frame .buttons
pack .buttons -side top
button .install -text "Install" -command do_install
button .cancel -text "Exit" -command "destroy ."
pack .install .cancel -in .buttons -side left -padx .1c

  wm withdraw .
  wm title . "tkgoodstuff Installation"
  update
  set x [expr ([winfo screenwidth .] - [winfo reqwidth .] )/2]
  set y [expr ([winfo screenheight .] - [winfo reqheight .] )/2]
  wm geometry . +$x+$y
  wm deiconify .

proc log {msg} {
    .log insert end "$msg"
    .log see end
    update
}

foreach name {wish4.0 wish} {
    log "Searching for $name..."
    foreach dir [split $env(PATH) :] {
	if [file executable $dir/$name] {
	    set wish $dir/$name
	    break
	}
    }
    if ![info exists wish] {
	log "not found!\n"
	continue
    }
    break
}
if [info exists wish] {
    log "using $wish\n"    
} else {
    set wish /usr/local/bin/wish4.0
    log "Hmm, using $wish anways...\n"
}

proc install_files {dir files} {
    foreach file $files {
	log "Copying $file to $dir..."
	if {[catch {exec rm -f $dir/[file tail $file]}] || [catch {exec cp $file $dir} error] || [catch {exec chmod 0444 $dir/[file tail $file]} error]} {
	    log "whoops: $error, install aborted.\n"
	    return 0
	}
	log "ok.\n"
    }
    return 1
}

proc regsub_quote {string} {
    regsub -all {\\([0-9])} $string {\\\\\1} string
    regsub -all "&" $string {\\&} string
    return $string
}

proc verify {name} {
    global bindir libdir wish
    if { ($name == "bindir") || ( $name == "libdir")} {
	set dir [set $name]
	if ![file exists $dir] {
	    set ans [tk_dialog .mkdir "Create Directory?" "The directroy $dir does not exists, should I create it?" question 0 "Yes" "Cancel Install"]
	    if {$ans == 1} {
		return 0
	    }
	    if [catch {exec mkdir $dir; exec chmod ugo+rx $dir} msg] {
		tk_dialog .error "Error Making Directory" "Couldn't make directory $dir: $msg" error 0 "Ok"
		return 0
	    }
	}
	return 1
    } elseif { $name == "wish" } {
	if ![file executable [set $name]] {
	    tk_dialog .error "Error" "Executable [set $name] isn't executable!" error 0 "Ok"
	    return 0
	}
	return 1
    }
}

proc install {} {
    global libdir bindir wish tkgoodstuff
    foreach w { bindir libdir wish} {
	log "Checking $w ..."
	if ![verify $w] {
	    log "install aborted\n"
	    return
	}
	log "ok.\n"
    }
    if ![file isdirectory $libdir/doc] {
	log "Making $libdir/doc directory..."
	if [catch {exec mkdir $libdir/doc; exec chmod ugo+rx $libdir/doc} error] {
	    log "whoops: $error, install aborted.\n"
	    return
	}
	log "ok.\n"
    }
    if ![file isdirectory $libdir/sample-rc] {
	log "Making $libdir/sample-rc directory..."
	if [catch {exec mkdir $libdir/sample-rc; exec chmod ugo+rx $libdir/sample-rc} error] {
	    log "whoops: $error, install aborted.\n"
	    return
	}
	log "ok.\n"
    }
    if ![file isdirectory $libdir/images] {
	log "Making $libdir/images directory..."
	if [catch {exec mkdir $libdir/images; exec chmod ugo+rx $libdir/images} error] {
	    log "whoops: $error, install aborted.\n"
	    return
	}
	log "ok.\n"
    }
    if ![install_files $libdir {
	Clock.tcl Biff.tcl Jots.tcl Net.tcl Ical.tcl Ical-fetch.tcl PopImap.tcl WWW.tcl 
        system-tkgoodstuffrc
    }] {
	return
    }

    if ![install_files $libdir/doc {
doc/biff.html               doc/minimal.gif             doc/tkgoodstuffrc-home-xpm
doc/clock.html              doc/net.html                doc/tkgoodstuffrc-minimal
doc/dialer.html             doc/popimap.html            doc/tkgoodstuffrc-stacks
doc/home-xpm.gif            doc/popup.gif               doc/tkgoodstuffrc.html
doc/ical.html               doc/running.html            doc/variables.html
doc/images.html             doc/stacks.gif              doc/writingclients.html
doc/jots.html               doc/tkgoodstuff.html        doc/www.html  
    }] {
	return
    }
    if ![install_files $libdir/images {
images/biffnew.xbm     images/jots.xpm        images/netwt.xbm       images/weather.xpm
images/biffnew.xpm     images/letters         images/netwt.xpm       images/www.xbm
images/biffno.xbm      images/netdn.xbm       images/news.xbm        images/www.xpm
images/biffno.xpm      images/netdn.xpm       images/newspap.xpm     images/xlogo.xpm
images/calendar.xbm    images/netscape.xbm    images/question        images/xlogo16
images/copyright.info  images/netscape.xpm    images/telnet.xpm
images/error           images/netup.xbm       images/terminal
images/jots.xbm        images/netup.xpm       images/warning
    }] {
	return
    }
    if ![install_files $libdir/sample-rc {
      sample-rc/tkgoodstuffrc-homesystem	   sample-rc/tkgoodstuffrc-minimal
      sample-rc/tkgoodstuffrc-stacks
    }] {
	return
    }
    set file Dialer
    set dir $bindir
    log "Copying $file to $dir..."
    if {[catch {exec rm -f $dir/[file tail $file]}] || [catch {exec cp $file $dir} error] || [catch {exec chmod 0555 $dir/[file tail $file]} error]} {
	log "whoops: $error, install aborted.\n"
	return 0
    }
    log "ok.\n"
    log "Making tkgoodstuff shell script..."
    if [catch {
	exec rm -f $bindir/tkgoodstuff
	set fp [open tkgoodstuff.tcl r]
	set text [read $fp]
	close $fp
	regsub -all @tkgoodstuff_library@ $text [regsub_quote $libdir] text
	regsub -all !/usr/local/bin/wish $text [regsub_quote !$wish] text
	set fp [open $bindir/tkgoodstuff w]
	puts $fp $text
	close $fp
	exec chmod 0555 $bindir/tkgoodstuff
    } error] {
	log "whoops: $error, install aborted.\n"
	return
    }
    log "ok.\n"
    log "Install finished.\n"
}

proc do_install {} {
    toplevel .grab
    wm withdraw .grab
    while [catch {grab set .grab}] {}
    set old_focus [focus -lastfor .grab]
    focus .grab
    install
    grab release .grab
    focus $old_focus
    destroy .grab
}

