# ----------------------------------------------------------------------
#  PURPOSE:  drag&drop send routine for "use_widget" data 
#            (a component and a widget name)
#
#  Widgets that are to participate in drag&drop operations for
#  "use_widget" data should be registered as follows:
#
#      blt_drag&drop source .win handler use_widget dd_send_use_widget
#      blt_drag&drop target .win handler use_widget my_use_widget_handler
#
#      proc my_use_widget_handler {} {
#          global DragDrop
#
#          set data $DragDrop(use_widget)
#            .
#            .  do something with $data
#            .
#      }
#
#   AUTHOR:  rf
#
# ======================================================================

# ----------------------------------------------------------------------
# COMMAND: dd_send_use_widget <interp> <ddwin> <data>
#
#   INPUTS
#     <interp> = interpreter for target application
#      <ddwin> = pathname for target drag&drop window
#       <data> = data returned from -tokencmd
#
#   RETURNS
#     ""
#
#   SIDE-EFFECTS
#     Sends data to remote application DragDrop(use_widget), and then
#     invokes the "use_widget" handler for the drag&drop target.
# ----------------------------------------------------------------------
proc dd_send_use_widget {interp ddwin data} {
   send $interp "
      global DragDrop
      set DragDrop(use_widget) [list $data]
   "
   send $interp "blt_drag&drop target $ddwin handle use_widget"
}
