# use_tclsh.tcl
# 
# Copyright (c) 1994 R"udiger Franke
# All Rights Reserved.
# 
# Redistribution and use in any form, with or without modification, 
# is permitted, provided that the following conditions are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in other form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#       This product includes software developed by R"udiger Franke.
# 4. The name of the author may not be used to endorse or promote products
#    derived from this software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
# IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
# NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#
# constructor for "use_tclsh"
#
proc use_tclsh {w interp args} {
  upvar #0 $w this

  # user initializations

  set this(interp) $interp
  
  # data initializations

  set this(use_tclsh) $w
  
  # widget creations

  text $this(use_tclsh) 
  
  useCreateComponent use_tclsh $w $args

  # user additions

  # initialize mark for prompt end
  
  $w mark set promptEnd insert
  $w prompt

  return $w
}

#
# method "delete"
#
proc use_tclsh::delete {w index1 {index2 {}}} {
  upvar #0 $w this

  # assert that nothing before prompEnd is deleted
  
  set text $w.use_tclsh
  if {[$text compare $index1 < {promptEnd + 1 char}]} {
    $text mark set insert {promptEnd + 1 char}
    set index1 insert
  }
  if {$index2 != {} && [$text compare $index2 < {promptEnd + 1 char}]} {
    $text mark set insert {promptEnd + 1 char}
    set index2 insert
  }
  if {$index2 != {}} {
    $text delete $index1 $index2
  } else {
    $text delete $index1
  }
}

#
# method "insert"
#
proc use_tclsh::insert {w index chars} {
  upvar #0 $w this

  # assert that nothing before promptEnd is inserted
  
  set text $w.use_tclsh
  if {[$text compare $index < {promptEnd + 1 char}]} {
    $text mark set insert end
    set index insert
  }
  eval [concat $text insert [list $index] [list $chars]]
  
  # call invoke after newline
  
  set end [string length $chars]
  incr end -1
  if {[string index $chars $end] == "\n"} {
    update idletasks
    $w invoke
  }
}

#
# method "interp"
#
proc use_tclsh::interp {w args} {
  upvar #0 $w this

  if {[llength $args] == 0} {
    return $this(interp)
  } else {
    set this(interp) [lindex $args 0]
    $w.use_tclsh mark set insert end
    $w.use_tclsh insert insert "\n"
    $w prompt
  }
}

#
# method "invoke"
#
proc use_tclsh::invoke {w } {
  upvar #0 $w this

  set cmd [$w get {promptEnd + 1 char} insert]
  if [info complete $cmd] {
    catch [list send $this(interp) $cmd] msg
    if {$msg != ""} {
      $w insert insert $msg
      $w.use_tclsh insert insert "\n"
    }
    $w prompt
  }
  
}

#
# method "prompt"
#
proc use_tclsh::prompt {w } {
  upvar #0 $w this

  $w insert insert "$this(interp): "
  $w mark set promptEnd {insert - 1 char}
  
  $w yview -pickplace insert
}

