/* useInit.c --
 *  initialize the USE package for a Tcl interpreter
 * 
 * Copyright (c) 1994 R"udiger Franke
 * All Rights Reserved.
 * 
 * Redistribution and use in any form, with or without modification, 
 * is permitted, provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in other form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by R"udiger Franke.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>

#include <tcl.h>
#include <tk.h>

#include "use.h"

int Use_Init(Tcl_Interp *interp)
{
  char *libDir;
  
  /*
   * init varable use_library
   */

  libDir = getenv("USE_LIBRARY");
  if (libDir == NULL) {
    libDir = USE_LIBRARY;
  }
  Tcl_SetVar(interp, "use_library", libDir, TCL_GLOBAL_ONLY);

  /*
   * init use commands
   */

  Tcl_CreateCommand(interp, "use_mainwin", useMainWinCmd,
  	            (ClientData)NULL, NULL);

  return TCL_OK;
}

