#!/usr/local/bin/wish -f
#
# SIMUL WINDOW
#
# This procedure allows the user to select a simulations or serial port
#

proc xSimul {} {

    global input_port \
	    serial_port \
	    baud \
	    stopbits \
	    framesize \
	    parity \
	    rbaud \
	    hto \
	    uto \
	    cto \
	    xNet_stopped

    set input_port dumm
    set serial_port dumf
    set title_f -Adobe-helvetica-bold-r-normal--*-120*
    set title_c brown
    set lab_font -Adobe-helvetica-medium-r-normal--*-120*


    catch {destroy .cSimul}
    toplevel .cSimul
    wm geometry .cSimul +300+100
    wm title .cSimul "SIM/PORT SELECT"
    wm iconname .cSimul "SIMUL"

    message .cSimul.msg \
	    -font -Adobe-helvetica-medium-r-normal--*-120* \
	    -text "Select input source, \nSimulation or Serial Port."\
	    -aspect 1000


    frame .cSimul.frame -relief raised -bd 2
    frame .cSimul.botframe
    frame .cSimul.frame.finput
    
    pack .cSimul.msg -side top
    pack .cSimul.frame -side top -fill x -expand yes -pady 2
    pack .cSimul.botframe -side bottom -fill x
    pack .cSimul.frame.finput -side left -expand yes -fill both
    
    

    #
    # SELECT INPUT PORT
    #
    radiobutton .cSimul.frame.finput.s0 \
	    -text "0. Serial Port" -fg red \
	    -font $lab_font -variable input_port -relief flat \
	    -value 0
    
    radiobutton .cSimul.frame.finput.s1 \
	    -text "1. Short Test 1" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim1.sh
    
    radiobutton .cSimul.frame.finput.s2 \
	    -text "2. Short Test 2" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim2.sh
    
    radiobutton .cSimul.frame.finput.s3 \
	    -text "3. Short Test 3" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim3.sh
    
    radiobutton .cSimul.frame.finput.s4 \
	    -text "4. Short Test 4" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim4.sh
    
    radiobutton .cSimul.frame.finput.s5 \
	    -text "5. Chicago 144.910 MHz" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim5.sh
    
    radiobutton .cSimul.frame.finput.s6 \
	    -text "6. Chicago 145.090 MHz" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim6.sh
    
    radiobutton .cSimul.frame.finput.s7 \
	    -text "7. Chicago 147.070MHz" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim7.sh
    
    radiobutton .cSimul.frame.finput.s8 \
	    -text "8. Dallas 144.930 MHz" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim8.sh
    
    radiobutton .cSimul.frame.finput.s9 \
	    -text "9. Dallas 145.010 MHz" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim9.sh
    
    radiobutton .cSimul.frame.finput.s10 \
	    -text "10. Dallas 145.090 MHz" \
	    -font $lab_font -variable input_port -relief flat \
	    -value sim10.sh
    
    pack    .cSimul.frame.finput.s0 .cSimul.frame.finput.s1 \
	    .cSimul.frame.finput.s2 .cSimul.frame.finput.s3 \
	    .cSimul.frame.finput.s4 .cSimul.frame.finput.s5 \
	    .cSimul.frame.finput.s6 .cSimul.frame.finput.s7 \
	    .cSimul.frame.finput.s8 .cSimul.frame.finput.s9 \
	    .cSimul.frame.finput.s10 \
	    -side top -pady 2 -anchor nw


    
    #
    # SAVE new Preferences to file and exit.
    #
    button .cSimul.botframe.save -text "SAVE" -width 12 -command {
	set fp [open prefs w]
	puts $fp $input_port
	puts $fp $serial_port
	puts $fp $baud
	puts $fp $stopbits
	puts $fp $framesize
	puts $fp $parity
	puts $fp $rbaud
	puts $fp $hto
	puts $fp $uto
	puts $fp $cto
	close $fp
	if {! $xNet_stopped} {attn_simul_dialog}
	destroy .cSimul
    }



    #
    # CANCEL Exit
    #
    button .cSimul.botframe.can -text "CANCEL" -width 12 -command {
	destroy .cSimul
    }

    pack .cSimul.botframe.can .cSimul.botframe.save -side left \
	    -fill x -expand yes -pady 2



    #
    # GET PREFERENCES
    #
    set pf [open prefs r]
    gets $pf input_port
    gets $pf serial_port
    gets $pf baud
    gets $pf stopbits
    gets $pf framesize
    gets $pf parity
    gets $pf rbaud
    gets $pf hto
    gets $pf uto
    gets $pf cto
    
    close $pf

}


proc attn_simul_dialog {} {

    toplevel .attn
    wm title .attn "ATTENTION"

    message .attn.msg \
	    -font -Adobe-helvetica-bold-r-normal--*-140* \
	    -width 2i -justify center -fg red\
	    -text "\n XNET RUNNING \n \n Saved changes used on next re-START."

    frame .attn.frame -relief raised -bd 2
    label .attn.bmap -bitmap warning -fg blue
    button .attn.ok -text "OK" -command {destroy .attn}


    pack .attn.msg -side top -anchor center
    pack .attn.bmap -side top -pady .25i
    pack .attn.ok -side left -expand yes -fill both


    # Wait for user to acknowledge warning dialog
    tkwait visibility .attn
    grab set -global .attn
    tkwait window .attn
    grab release .attn


}