## -- referencePager.t

# return 0 for OK
#       -1 for error (connection went away)
#        1 reflist is empty
#
# if a reference list is not supplied then the reference list from 
# ArticleHeader is used
#
proc referencePager {{reflist None}} {
    global Server Groups ShowArticleHeaders ArticleHeader
    if {$reflist == "None"} {
	if {[info exists ArticleHeader(References)]} {
	    set reflist [hdrMsgIds $ArticleHeader(References)]
	} else {
	    return 1
	}
    }
    if {[llength $reflist] == 0} {
	return 1
    }
    if {![pagerCreate .references toplevel "fetching references.."]} {
	pack unpack .references.mb
	destroy .references.mb
    }

    # build the data structure makeMenubar wants...
    set item_defs {}
    foreach r $reflist {
	lappend item_defs $r 
	lappend item_defs command 
	lappend item_defs "getReference .references $r"
    }
    # ...and call it
    makeMenuBar .references [list "References" $item_defs]

    # then go ahead and get the 1st reference in the list...
    getReference .references [lindex $reflist 0]
    pack append .references .references.mb {top fill}
}

proc getReference {w msgid} {
    global Server
    # delete old text if any
    listBoxClear $w.list.box
    # make request for new text
    nntpPuts "ARTICLE $msgid"
    # get response
    # 222 nnn <aaa> - article retrieved body follows
    gets $Server(in) resp
    scan $resp "%d %d" code artnum
    case $code {22?} {
	while {[gets $Server(in) ln]>=0} {
	    case $ln {.\r .} {
		return 0
	    } {..*} {
		listBoxAppendLine $w [string range $ln 1 end]
	    } default {
		listBoxAppendLine $w $ln
	    }
	}
	# connection blew up
	showMsg $w $msgid
	return -1
    } default {
	showMsg $w "$resp"
	return 1
    }
    return 0
}
