# Bindings for balancing paranethesis (and other character pairs)


# Returns index of matching left partner, or "" if unsuccessful.
proc find_left_partner {t left right} {
	set left [string trimleft $left \\]
	set right [string trimleft $right \\]
	set close_trace [$t index insert]
	set open_trace $close_trace
	while (1) {
# Go back 1 left, quit if none found.
		set backset [string last $left [$t get 1.0 $open_trace]]
		if {($backset < 0)} {return ""}
		set open_trace [$t index "1.0 +$backset chars"]
# Go back 1 right, if none after open, return current open
		set offset [string last $right [$t get \
					$open_trace $close_trace]]
		if {($offset < 0)} {return $open_trace}
		set close_trace [$t index "$open_trace +$offset chars"]
}}

# Counts instances of $c between $start and $end in $t
proc char_count {t c start end} {
	set offset 0 ; set count 0
	set c [string trimleft $c \\]
	while {([set offset [string first $c [$t get $start $end]]] >= 0)} {
		incr count
		set start [$t index "$start +$offset chars +1 chars"]
	}
	return $count
}

# Checks if $left and $right occur the same # of times in [$start $end] of $t
proc balance_count {t left right start end} {
	set c1 [char_count $t $left $start $end]
	set c2 [char_count $t $right $start $end]
	if {($c1 > $c2)} {return "[string trimleft $left \\] [expr $c1-$c2]"}
	if {($c2 > $c1)} {return "[string trimleft $right \\] [expr $c2-$c1]"}
	return ""
}

proc search_left_partner {t f left right} {
	global balance_list
	catch {$t tag remove balance 1.0 end}
	set result [find_left_partner $t $left $right]
	if {($result == "")} {
		set msg "No [string trimleft $left \\] found!!!" ; beep
	} else {$t tag add balance $result "$result +1 chars"
		global flash_time
		after $flash_time $t tag remove balance 1.0 end
		foreach pair $balance_list {if {($left != [lindex $pair 0])} {
			set char [balance_count $t [lindex $pair 0] \
				[lindex $pair 1] $result insert]
			if {($char != "")} {
				set msg "Excess $char" ; beep ; break
			} else {set msg [$t get "$result linestart" \
					"$result +1 chars"]
	}}}}
	set max_length 20
	if {([string length $msg] < $max_length)} {set width [string length $msg]} else {set width $max_length}
	flash_label $f -text $msg -relief raised -width $width -anchor e
}


# Balance bindings. f is a frame widget to put messages in.
proc balancebind {f m} {
	global balance_list
	if {[winfo exists $m]} {make_cascade_entry $m.extras.m Find 0}

	foreach pair $balance_list {
		set left_key [lindex $pair 0]
		set right_key [lindex $pair 1]
		set right_keysym [lindex $pair 2]
		bind Text <$right_keysym> "search_left_partner %W $f \
						\\$left_key \\%A ;
				catch {self_insert %W %A}"

		if {[winfo exists $m]} {
			make_command_entry $m.extras.m.find "Partner to" \
						"$right_keysym $right_key"}
}}

if {![info exists balancebind_loaded]} {
	balancebind $frame $menu
	flash_label $frame -text "Loaded balance bindings"
	set balancebind_loaded 1
}
