# Bindings for managing the Beth window.


# Beth grab control

proc take_control {f} {
	catch {label $f.grab -text "Grab"}
	pack $f.grab -side left
	update ; update idletasks
	catch {grab -global .}
}

proc relinquish_control {f} {
	catch {grab release .}
	catch {destroy $f.grab}
}

proc toggle_control {f} {
	if {([grab status .] != "none")} {relinquish_control $f
	} else {take_control $f}
}

proc wm_raise {f} {
	set regrab [grab status .]
	wm iconify . ; wm deiconify .
	if {($regrab != "none")} {relinquish_control $f; take_control $f}
}


# Window configuration options
# To resize windows, we do a widget_resize on the text widget

# Used in a hack in window_move, this gets set to the outer border width later.
set border ""

# Returns proper window geometry (i.e. doing wm geometry . results does the
# Right Thing)
proc wm_geometry {} {
	scan [wm geometry .] {%dx%d+%d+%d} h v hp vp
	global border
	if {($border == "")} {
		scan [winfo geometry .] {%dx%d+%d+%d} ih iv ihp ivp
		set border [expr "$ihp - $hp"]
	}
	return "$hp $vp"
}

# Moves window up/down/left/right based on option and d (same as widget_resize)
proc window_move {option d} {
	set grid [wm grid .]
	scan [wm_geometry] "%d %d" hp vp

	if {($option == "-width")} {incr hp [expr "(0 $d)*[lindex $grid 2]"]
	} else {incr vp [expr "(0 $d)*[lindex $grid 3]"]}

	wm geometry . "+$hp+$vp"
	update ; update idletasks
}

# Puts window on top/left edge of scrren based on option.
proc window_set {option} {
	global border
	scan [wm_geometry] "%d %d" hp vp

	if {($option == "-width")} {set string "+$border+$vp"
	} else {		set string "+$hp+$border"}

	wm geometry . $string
	update ; update idletasks
}


# Command execution

# Executes cmds, but meanwhile declares that Beth is busy.
proc beth_busy {t args} {
	update ; update idletasks

	# Indicate process is busy
	set cursor [lindex [$t config -cursor] 4]
	set offtime [lindex [$t config -insertofftime] 4]
	$t config -cursor watch -insertofftime 0
	set title [wm title .];	set iconname [wm iconname .]
	wm title . "*BUSY* $title";	wm iconname . "* $iconname"
	update ; update idletasks

	set error [catch {uplevel eval [list $args]} result]

	# Free up program now.
	wm title . $title ; 	wm iconname . $iconname
	update ; update idletasks
	$t config -cursor $cursor -insertofftime $offtime
	if $error {	tkerror $result} else {	return $result
}}

# Figures out how to undo inserting output into text widget.
proc figure_out_undo_insert {t output} {
	global modified ; 	set modified 1

	# Figure out how to undo pasting command.
	set ustart [gensym];	set uend [gensym]
	$t mark set $uend insert
	$t mark set $ustart "insert -[string length $output] chars"
	register_undoable_cmd $t [list $t delete $ustart $uend] "Insert $output" "$ustart $uend"
}

# Inserts some output into text widget.
proc insert_output {t output} {
	global edit_flag
	if {$output == ""} {return}
	if {(!$edit_flag)} {
		tkerror "can't insert:\n$output"
		return 0
	}
	$t insert insert "$output\n"
	figure_out_undo_insert $t "$output\n"
}

# Execs a command to exec
proc execute_shell_command {t cmd} {
	set use_input 0;	set use_output 0
	if {[string match \|* $cmd]} {
		set cmd [string range $cmd 1 [expr [string length $cmd] - 1]]
		set use_input 1
	}
	if {[string match *\| $cmd]} {
		set cmd [string range $cmd 0 [expr [string length $cmd] - 2]]
		set use_output 1
	}

	if {$use_input} {
		global default_tmpfile
		if {([catch {$t get sel.first}])} {
			set beginning 1.0
			set end end
		} else {set beginning sel.first
			set end sel.last
		}
		set p [open $default_tmpfile w+]
		puts $p [$t get $beginning $end]
		flush $p
		seek $p 0
		set er [catch "eval exec <@ $p $cmd" output]
		close $p
		exec rm $default_tmpfile
	} else {set er [catch "eval exec $cmd" output]}

	if {$use_output} {insert_output $t $output
	} elseif $er {tkerror $output
}}

# Executes shell command, after prompting user for cmd.
proc setup_shell_cmd_aux {t l e default_cmd} {
	set cmd [$e get]
	destroy_f_entry $t $l $e
	global $default_cmd ; 	set $default_cmd $cmd

	set index [$t index insert]

	beth_busy $t execute_shell_command $t $cmd
}

# Prompts user for a shell cmd.
proc setup_shell_cmd {t f {prompt "Cmd to execute:"} {default_cmd sh_cmd}} {
	global $default_cmd default_tmpfile
	if {($default_cmd == "sh_cmd")} {set $sh_cmd ""}
	create_f_entry $t $f.shl $f.she
	$f.shl configure -text $prompt
	$f.she insert 0 [set $default_cmd]
	bind $f.she <Return> "setup_shell_cmd_aux $t $f.shl $f.she $default_cmd"
	bind $f.she <KP_Enter> "[bind $f.she <Return>]"
}

# Execs a command in wish
proc execute_wish_command {t cmd} {
	set use_output 0
	if {[string match *\| $cmd]} {
		set cmd [string range $cmd 0 [expr [string length $cmd] - 2]]
		set use_output 1
	}

	set er [catch {uplevel #0 $cmd} output]

	if {$use_output} {insert_output $t $output
	} elseif $er {tkerror $output
}}

# Executes wish command, after prompting user for cmd.
proc setup_wish_cmd_aux {t l e default_cmd} {
	set cmd [$e get]
	destroy_f_entry $t $l $e
	global $default_cmd ; 	set $default_cmd $cmd

	set index [$t index insert]

	beth_busy $t execute_wish_command $t $cmd
}

# Default command to send to wish
set wish_cmd ""

# Prompts user for a wish cmd.
proc setup_wish_cmd {t f} {
	global wish_cmd
	create_f_entry $t $f.shl $f.she
	$f.shl configure -text "Wish Command:"
	$f.she insert 0 $wish_cmd
	bind $f.she <Return> "setup_wish_cmd_aux $t $f.shl $f.she wish_cmd"
	bind $f.she <KP_Enter> "[bind $f.she <Return>]"
}


# Window and command bindings. f is a frame widget to put messages in.
proc windowbind {f} {
	bind Text <Control-g> "+catch \{destroy_f_entry %W $f.shl $f.she\}"

	bind Text <Meta-Control-c> "toggle_control $f"
	bind Text <Meta-Control-e> "setup_shell_cmd %W $f {Exec Command:} shell_cmd"
	bind Text <Meta-Control-h> "setup_shell_cmd %W $f {Help Command: (Press Return to view help)} help_cmd"
	bind Text <Meta-i> "wm_raise $f"
	bind Text <Meta-Control-m> "setup_shell_cmd %W $f {Make Command:} make_cmd"
	bind Text <Meta-Control-p> "setup_shell_cmd %W $f {Print Command:} print_cmd"
	bind Text <Meta-Control-w> "setup_wish_cmd %W $f"
	bind Text <Meta-Control-x> "setup_shell_cmd %W $f {Browse-Selection Command:} browse_cmd"
	bind Text <Control-bracketleft> "widget_resize %W -height -1"
	bind Text <Control-bracketright> "widget_resize %W -width -1"
	bind Text <Control-braceleft> "widget_resize %W -height +1"
	bind Text <Control-braceright> "widget_resize %W -width +1"
	bind Text <Meta-bracketleft> "window_move -height -1"
	bind Text <Meta-bracketright> "window_move -width -1"
	bind Text <Meta-braceleft> "window_move -height +1"
	bind Text <Meta-braceright> "window_move -width +1"
	bind Text <Control-Meta-bracketleft> "window_set -height"
	bind Text <Control-Meta-bracketright> "window_set -width"

# Duplicate bindings
	bind Text <Control-Left> [bind Text <Control-bracketright>]
	bind Text <Control-Right> [bind Text <Control-braceright>]
	bind Text <Control-Up> [bind Text <Control-bracketleft>]
	bind Text <Control-Down> [bind Text <Control-braceleft>]
	bind Text <Meta-Left> [bind Text <Meta-bracketright>]
	bind Text <Meta-Right> [bind Text <Meta-braceright>]
	bind Text <Meta-Up> [bind Text <Meta-bracketleft>]
	bind Text <Meta-Down> [bind Text <Meta-braceleft>]
	bind Text <Control-Meta-Left> [bind Text <Control-Meta-bracketright>]
	bind Text <Control-Meta-Up> [bind Text <Control-Meta-bracketleft>]
}

windowbind $frame

after 2000 {flash_label $frame -text "Press Meta-Control-h for help"}
