#!/usr/local/bin/wish -f
#
# evap - essentially identical to the C version of sample!
     
source "src/evap.tcl"

set PDT \
{PDT (./libevapmm.a/sample.mm) sample
  verbose, v: switch
  command, c: string = D_SAMPLE_COMMAND, "ps -el"
  scale_factor, sf: real = 1.2340896e-1
  millisecond_update_interval, mui: integer = $required
  ignore_output_file_column_one, iofco: boolean = TRUE
  output, o: file = stdout
  queue, q: key plotter, postscript, text, printer, keyend = printer
  destination, d: application = `hostname`
  tty, t: list of name = ("/dev/console", "/dev/tty0", "/dev/tty1")
PDTEND optional_file_list}

set MM \
{sample

	A sample program demonstrating typical evaluate_parameters
	usage.

	Examples:

	  sample
	  sample -usage_help
	  sample -?
	  sample -full_help
          sample -mui 1234
.verbose
        A 'switch' type parameter emulates a typical standalone
        switch. If the switch is specified evaluate_parameters
        returns a '1'.
.command
        A 'string' type parameter is just a list of characters,
        which must be quoted if it contains whitespace. 
        NOTE:  for this parameter you can also create and
        initialize the environment variable D_SAMPLE_COMMAND to
        override the standard default value for this command
        line parameter.  All types except 'switch' may have a
        default environment variable for easy user customization.
.scale_factor
        A 'real' type parameter must be a real number that may
        contain a leading sign, a decimal point and an exponent.
.millisecond_update_interval
        An 'integer' type parameter must consist of all digits
        with an optional leading sign.  NOTE: this parameter's
        default value is '$required', meaning that
        evaluate_parameters ensures that this parameter is
        specified and given a valid value.  All types except
        'switch' may have a default value of '$required'.
.ignore_output_file_column_one
        A 'boolean' type parameter may be TRUE/YES/ON/1 or
        FALSE/NO/OFF/0, either upper or lower case.  If TRUE,
        evaluate_parameters returns a value of '1', else '0'.
.output
        A 'file' type parameter expects a filename.  For Unix
        $HOME and ~ are expanded.
.queue
        A 'key' type parameter enumerates valid values.  Only the
        specified keywords can be entered on the command line.
.destination
	An 'application' type parameter is not type-checked in
	any - the treatment of this type of parameter is
	application specific.  NOTE:  this parameter' default
	value is enclosed in grave accents (or "backticks").
	evaluate_parameters executes the command and uses it's
	standard output as the default value for the parameter.
.tty
	A 'name' type parameter is similar to a string except
	that embedded white-space is not allowed.  NOTE: this
	parameter is also a LIST, meaning that it can be
	specified multiple times and that each value is pushed
        onto a Tcl LIST variable.}

set PDT [split $PDT "\n"]
set MM [split $MM "\n"]

evap $PDT $MM;			# evaluate parameters
puts -nonewline "\nProgram name:\n  $opt_help\n\n"

if { [info exists opt_verbose] } { puts -nonewline "verbose = $opt_verbose\n" }
puts -nonewline "command = \"$opt_command\"\n"
puts -nonewline "scale_factor  = $opt_scale_factor\n"
puts -nonewline "millisecond_update_interval = $opt_millisecond_update_interval\n"
puts -nonewline "ignore_output_file_column_one = $opt_ignore_output_file_column_one\n"
puts -nonewline "output = $opt_output\n"
puts -nonewline "queue = $opt_queue\n"
puts -nonewline "destination = $opt_destination\n"
puts -nonewline "'list of' tty = \"[join $opt_tty {", "}]\"\n"

if { $argc > 0 } {
    puts -nonewline "\nFile names:\n  [join $argv { }]\n"
}

exit 0
