/* Copyright (c) 1993 by Sanjay Ghemawat */
/*
 * Miscellaneous Tcl commands.
 */

#include <ctype.h>
#include <stdio.h>
#include <string.h>
extern "C" {
#include <tcl.h>
}

#include "commands.h"
#include "misc_tcl.h"

/*
 * Check if character has specified class
 *
 *	cclass <class> <char>	Returns boolean.
 *
 * Legal classes are
 *
 *	digit
 *	alpha
 *	alphanum
 *	printable
 *	space
 *	upper
 *	lower
 *	punctuation
 */
int Cmd_CharClass(ClientData, Tcl_Interp* tcl, int argc, char* argv[]) {
    if (argc != 3) {
	TCL_Error(tcl, "illegal number of arguments");
    }

    if (strlen(argv[2]) != 1) {
	TCL_Return(tcl, "0");
    }

    char c = argv[2][0];

    if (strcmp(argv[1], "digit") == 0) {
	TCL_Return(tcl, (isascii(c) && isdigit(c)) ? "1" : "0");
    }
    if (strcmp(argv[1], "alpha") == 0) {
	TCL_Return(tcl, (isascii(c) && isalpha(c)) ? "1" : "0");
    }
    if (strcmp(argv[1], "alphanum") == 0) {
	TCL_Return(tcl, (isascii(c) && isalnum(c)) ? "1" : "0");
    }
    if (strcmp(argv[1], "printable") == 0) {
	TCL_Return(tcl, (isascii(c) && isprint(c)) ? "1" : "0");
    }
    if (strcmp(argv[1], "space") == 0) {
	TCL_Return(tcl, (isascii(c) && isspace(c)) ? "1" : "0");
    }
    if (strcmp(argv[1], "upper") == 0) {
	TCL_Return(tcl, (isascii(c) && isupper(c)) ? "1" : "0");
    }
    if (strcmp(argv[1], "lower") == 0) {
	TCL_Return(tcl, (isascii(c) && islower(c)) ? "1" : "0");
    }
    if (strcmp(argv[1], "punctuation") == 0) {
	TCL_Return(tcl, (isascii(c) && ispunct(c)) ? "1" : "0");
    }

    TCL_Error(tcl, "unknown character class");
}
