# Copyright (c) 1993 by Sanjay Ghemawat
###############################################################################
# Various Support Routines
#
# Global Variables
#
#	month_name		Array of month names
#	weekday_name		Array of weekday names
#

proc support_init {} {
    global month_name
    catch {unset month_name}

    set month_name(1)	January
    set month_name(2)	February
    set month_name(3)	March
    set month_name(4)	April
    set month_name(5)	May
    set month_name(6)	June
    set month_name(7)	July
    set month_name(8)	August
    set month_name(9)	September
    set month_name(10)	October
    set month_name(11)	November
    set month_name(12)	December

    global weekday_name
    catch {unset weekday_name}

    set weekday_name(1)	Sunday
    set weekday_name(2)	Monday
    set weekday_name(3)	Tuesday
    set weekday_name(4)	Wednesday
    set weekday_name(5)	Thursday
    set weekday_name(6)	Friday
    set weekday_name(7)	Saturday
}

proc calendar_filenames {} {
    set list ""
    lappend list [cal main]
    cal forincludes x {
	lappend list $x
    }
    return $list
}

# effects - If listName contains specified string, remove it from the list
#	    and return 1.  Else return 0.

proc lremove {listName string} {
    upvar $listName list

    set i [lsearch $list $string]
    if {$i >= 0} {
	set list [lreplace $list $i $i]
	return 1
    } else {
	return 0
    }
}

# requires - item occurs on date.  leader is either "" or a top-level window.
# effects -  If item does not repeat, return "unnecessary".
#
#	     If item repeats, but user interaction says it is ok to
#	     modify all items, return "ok".
#
#	     If item repeats, but user interaction says it is ok to
#	     modify this instance, split item up so that modifications
#	     will only happen to the instance on date, and return "instance".
#
#	     If item repeats, and user interaction cancels the current
#	     operation, return "cancel".

proc repeat_check {leader item date} {
    if ![$item repeats] {return "unnecessary"}

    set result [yes_no_cancel $leader\
		"This item repeats.  Should all occurrences be changed?"\
		"Yes" "Just this one" "Cancel"
	       ]

    if {$result == "cancel"} {
	return "cancel"
    }

    if {$result == "yes"} {
	return "ok"
    }

    # Split item into two items.  One item only occurs on this
    # date.  The other item covers the rest of the occurrences.

    set copy [$item clone]
    $copy deleteon $date

    $item date $date

    cal changed $item
    cal add $copy [$item calendar]

    return "instance"
}

# effects - Print usage message and exist
proc usage {} {
    puts stderr {Usage: ical [options]
       -calendar <file>              ; Calendar file
       -list                         ; List imminent items
       -show +days                   ; Like "-list" but covers more days
       -readonly                     ; Do not allow any modifications
       [standard X options]          ; Only if on X display}
    exit 1
}
