# Copyright (c) 1993 by Sanjay Ghemawat
###############################################################################
# User Preferences

# Autload support
proc pref {} {}

class Preference {} {
    $self reload
}

method Preference reload {} {
    option clear

    # Load option files
    global libdir
    option readfile $libdir/common.options startupFile
    if {[tk colormodel .] == "color"} {
	option readfile $libdir/color.options startupFile
    } else {
	option readfile $libdir/mono.options startupFile
    }

    $self fixfonts

    # Get font dimensions
    canvas .prefc
    set f [.prefc create text 0 0 -text "00:00AM"\
	   -font [option get . itemFont Font]]
    set fbox [.prefc bbox $f]
    destroy .prefc
    set fontHeight [expr [lindex $fbox 3]-[lindex $fbox 1]+1]
    set textWidth  [expr [lindex $fbox 2]-[lindex $fbox 0]+1]

    # Cache various entries
    set slot(itemPad)		[winfo pixels . [option get . itemPad Size]]
    set slot(itemLineHeight)	[expr $fontHeight+2*$slot(itemPad)]
    set slot(apptLabelWidth)	[expr $textWidth+2*$slot(itemPad)]

    # Use command-line geometry specification (if any)
    global geometry
    if ![catch {set geometry}] {
	# Specified on command line
	option add Ical.DayView.geometry $geometry
    }

    # XXX People do not seem to like the motif-style popup behavior
    global tk_strictMotif
    if {!$tk_strictMotif} {
	bind Menubutton <Any-ButtonRelease-1> {tk_mbUnpost}
    }
}

# Fix fonts in option database
method Preference fixfonts {} {
    set slot(fontfamilies) [list\
			    [option get . fontFamily String]\
			    times\
			    charter\
			    {new century schoolbook}\
			    courier\
			    helvetica\
			   ]

    # Find fonts
    set canvas [canvas .preffonts]
    set norm140		[$self findfont $canvas medium r 140]
    set ital140		[$self findfont $canvas medium i 140]
    set bold140		[$self findfont $canvas bold   r 140]
    set norm180		[$self findfont $canvas medium r 180]
    set bold180		[$self findfont $canvas bold   r 180]
    set norm240		[$self findfont $canvas medium r 240]
    destroy $canvas

    # Set option database
    option add *weekdayFont		$norm140 startupFile
    option add *weekendFont		$ital140 startupFile
    option add *interestFont		$bold140 startupFile
    option add *itemFont		$norm140 startupFile

    option add *smallHeadingFont	$bold140 startupFile
    option add *largeHeadingFont	$norm240 startupFile

    option add *Dialog*font		$norm180 startupFile
    option add *Button*font		$bold180 startupFile
    option add *Dayview*Button*font	$bold140 startupFile
    option add *Label*font		$norm180 startupFile
    option add *Menubutton*font		$norm140 startupFile
    option add *Menu*font		$norm140 startupFile
    option add *Listbox*font		$norm140 startupFile
    option add *Text*font		$norm140 startupFile
    option add *Scale*font		$norm140 startupFile
}

# effects - Find font matching given specification
method Preference findfont {canvas weight style size} {
    # Search for this size in families
    foreach family $slot(fontfamilies) {
	set f "-*-$family-$weight-$style-normal-*-*-$size-*"
	if ![catch {$canvas create text 0 0 -text XXX -font $f}] {
	    $canvas delete all
	    return $f
	}
    }

    # XXX - More searching?

    # Return default font
    return fixed
}

# To force autoload
method Preference init {} {
}

# Methods for obtaining various preferences.

method Preference weekdayFont {} {
    return [option get . weekdayFont Font]
}

method Preference weekendFont {} {
    return [option get . weekendFont Font]
}

method Preference interestFont {} {
    return [option get . interestFont Font]
}

method Preference itemFont {} {
    return [option get . itemFont Font]
}

method Preference smallHeadingFont {} {
    return [option get . smallHeadingFont Font]
}

method Preference largeHeadingFont {} {
    return [option get . largeHeadingFont Font]
}

method Preference weekdayColor {} {
    return [option get . weekdayColor Foreground]
}

method Preference weekendColor {} {
    return [option get . weekendColor Foreground]
}

method Preference interestColor {} {
    return [option get . interestColor Foreground]
}

method Preference itemFg {} {
    return [option get . itemFg Foreground]
}

method Preference itemBg {} {
    return [option get . itemBg Background]
}

method Preference itemSelectFg {} {
    return [option get . itemSelectFg Background]
}

method Preference itemSelectBg {} {
    return [option get . itemSelectBg Foreground]
}

method Preference itemSelectWidth {} {
    return [option get . itemSelectWidth Size]
}

method Preference apptLineColor {} {
    return [option get . apptLineColor Foreground]
}

method Preference itemLineHeight {} {
    return $slot(itemLineHeight)
}

method Preference itemPad {} {
    return $slot(itemPad)
}

method Preference apptLabelWidth {} {
    return $slot(apptLabelWidth)
}

method Preference pollSeconds {} {
    return [option get . pollSeconds Time]
}

Preference-with-name pref
