# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Yes/No Dialog
#
# Commands
#
#	yes_or_no <leader> <message> <yes-text>? <no-text>?
#		Confirm with user.

# Hidden global variables
#
#	yn_init			Created yn dialog window?
#	yn_done			Is yes_or_no interaction finished

set yn_init 0
set yn_done 0

proc yes_or_no {leader message {y Okay} {n Cancel}} {
    yn_make
    return [yn_interact $leader $message $y $n]
}

proc yn_make {} {
    global yn_init yn_done
    if {$yn_init} {return}
    set yn_init 1

    set f .yn_dialog

    toplevel $f -class Dialog
    wm title $f Confirm
    wm protocol $f WM_DELETE_WINDOW {set yn_done 0}

    frame $f.top -relief raised -bd 1
    frame $f.bot -relief raised -bd 1
    frame $f.bot.default -relief sunken -bd 1

    message $f.text -aspect 400 -text {Uninitialized message}

    button $f.yes -text Okay -command {set yn_done 1}
    button $f.no -text Cancel -command {set yn_done 0}

    pack append $f.top $f.text {right expand fill padx 5m pady 5m}

    pack append $f.bot.default $f.yes {left padx 3m pady 3m}
    pack append $f.bot $f.no {left expand padx 5m pady 5m}
    pack append $f.bot $f.bot.default {left expand}

    pack append $f $f.top {top expand fill}
    pack append $f $f.bot {bottom fill}

    bind $f <Control-c> {set yn_done 0}
    bind $f <Return> {set yn_done 1}

    wm withdraw $f
    update
}

proc yn_interact {leader message y n} {
    global yn_done
    set f .yn_dialog

    # Fix dialog contents
    $f.text configure -text $message
    $f.yes configure -text $y
    $f.no configure -text $n

    # Run dialog
    set yn_done -1
    dialog_run $leader $f $f yn_done

    return $yn_done
}
