/* Copyright (c) 1994 Sanjay Ghemawat */
#include "options.h"
#include "misc.h"

OptionMap::~OptionMap() {
    for (OptionMap_Bindings b = rep; b.ok(); b.next()) {
	delete [] ((char*) b.key());
	delete [] ((char*) b.val());
    }
    delete rep;
}

void OptionMap::store(char const* key, char const* value) {
    char const* old_value;
    if (rep->fetch(key, old_value)) {
	// Replace old value with new
	rep->store(key, copy_string(value));
	delete [] ((char*) old_value);
    }
    else {
	// Insert new value
	rep->store(copy_string(key), copy_string(value));
    }
}

implementOpenHashMap(OptionMapRep,char const*,char const*,hash_string,eq_opt)
