# Copyright (c) 1993 by Sanjay Ghemawat
#############################################################################
# Yes/No/Cancel Dialog
#
# Commands
#
#	yes_no_cancel <leader> <message> <yes-text>? <no-text>? <cancel-text>?
#		Confirm with user.

# Hidden global variables
#
#	ync_init		Created ync dialog window?
#	ync_done		State of yes_no_cancel interaction

set ync_init 0
set ync_done active

proc yes_no_cancel {leader message {y Yes} {n No} {c Cancel}} {
    ync_make
    return [ync_interact $leader $message $y $n $c]
}

proc ync_make {} {
    global ync_init ync_done
    if {$ync_init} {return}
    set ync_init 1

    set f .ync_dialog

    toplevel $f -class Dialog
    wm title $f Confirm
    wm protocol $f WM_DELETE_WINDOW {set ync_done cancel}

    frame $f.top -relief raised -bd 1
    frame $f.bot -relief raised -bd 1
    frame $f.bot.default -relief sunken -bd 1

    message $f.text -aspect 400 -text {Uninitialized message}

    button $f.yes -text Yes -command {set ync_done yes}
    button $f.no -text No -command {set ync_done no}
    button $f.cancel -text No -command {set ync_done cancel}

    pack append $f.top $f.text {right expand fill padx 5m pady 5m}

    pack append $f.bot $f.cancel {left expand padx 5m pady 5m}
    pack append $f.bot $f.no {left expand padx 5m pady 5m}
    pack append $f.bot.default $f.yes {left padx 3m pady 3m}
    pack append $f.bot $f.bot.default {left expand}

    pack append $f $f.top {top expand fill}
    pack append $f $f.bot {bottom fill}

    bind $f <Return> {set ync_done yes}
    bind $f <n> {set ync_done no}
    bind $f <Control-c> {set ync_done cancel}

    wm withdraw $f
    update
}

proc ync_interact {leader message y n c} {
    global ync_done
    set f .ync_dialog

    # Fix dialog contents
    $f.text configure -text $message
    $f.yes configure -text $y
    $f.no configure -text $n
    $f.cancel configure -text $c

    # Run dialog
    set ync_done active
    dialog_run $leader $f $f ync_done

    return $ync_done
}
