/* 
 * main.c --
 *
 *	The main program for the editor application built around the
 *	mxedit TK widget.
 *
 * Copyright (c) 1992 Xerox Corporation.
 * Use and copying of this software and preparation of derivative works based
 * upon this software are permitted. Any distribution of this software or
 * derivative works must comply with all applicable United States export
 * control laws. This software is made available AS IS, and Xerox Corporation
 * makes no warranty about the software, its performance or its conformity to
 * any specification.
 */

#ifndef lint
static char rcsid[] = "$Header: /project/tcl/src/mxedit/RCS/main.c,v 2.2 1993/06/25 22:41:01 welch Exp welch $ SPRITE (Berkeley)";
#endif

#include "tk.h"
#include "tkConfig.h"
#include "tkInt.h"
#include "mxWidget.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

/*
 * Boilerplate for signal handling
 */

#include <signal.h>
#include <setjmp.h>
void intrhandler();
jmp_buf envX;
void (*oldhandler)();

int mxNumWindows = 0;	/* Global count of open windows */
int mxDontFork = 0;

/*
 * This is a stub needed to link against the Extended Tcl library.
 */
Tcl_Interp *tk_mainInterp = NULL;

Tk_Window MxGlobalWindow();

/*
 * main --
 *	This is basically a call to the MxOpenCmd to create the first window.
 *	argc and argv are passed through, and it turns out to be the
 *	mxinit TCL proc that handles opening a new window for each file.
 */
int
main(argc, argv)
    int argc;
    char **argv;
{
    void sig_setup();
    void terminate();
    Tk_Window gblTkwin;
    Tcl_Interp *gblInterp;

    sig_setup(NULL);
    if (setjmp(envX)) {
	terminate(NULL);
    }

    {	/* From rsalz@osf.org */
	char **new, *p; int i;

	new = (char **)malloc((argc + 2) * sizeof (char *));
	for (i = 0; p = argv[i]; i++) new[i] = strcpy(malloc(strlen(p) + 1), p);
	new[i] = NULL;
	argv = new;
    }
    if (strcmp(argv[0], "mxeditfg") == 0) {
	mxDontFork = 1;
    }
    /*
     * Create a single global interpreter and associated window.
     */
    gblInterp = Tcl_CreateInterp();
    gblTkwin = MxGlobalWindow(gblInterp, argc, argv);

    /*
     * Create the first file window.
     */
    MxOpenCmd((ClientData)gblInterp, tk_mainInterp, argc, argv);

    /*
     * Detach after windows have been created.
     */
    if (! mxDontFork) {
	int childpid;
	childpid = fork();
	if (childpid != 0) {
	    /* Parent Process */
	    exit(0);
	}
	/*
	 * Set up a new session so that Control-C in the bourne shell
	 * won't kill this process.  If setsid() isn't supported,
	 * then you might try setpgrp(getpid(), getpid()).
	 */
	setsid();
    }

    while (mxNumWindows > 0) {
	Tk_DoOneEvent(0);
	Mx_CheckFileState();
    }
    MxDestroyGlobalWindow(gblTkwin, gblInterp);
    exit(0);
}

/*
 * MxEnvironmentSetup --
 *	Common setup code between MxOpenCmd and MxGlobalWindow
 *	to set up interpreter values for the per-window
 *	and per-process interpreters.
 *
 *	Results:
 *		A pointer to an arg string allocated by Tcl_Merge
 */

char *
MxEnvironmentSetup(tkwin, interp, libDir, argc, argv)
    Tk_Window tkwin;
    Tcl_Interp *interp;
    char *libDir;
    int argc;
    char *argv[];
{
    char *args;
    struct stat statBuf;
    char buf[10];

    Tk_SetClass(tkwin, "Mxedit");
    Tcl_SetVar(interp, "mxInterpName", Tk_Name(tkwin), TCL_GLOBAL_ONLY);

    if (argc > 1) {
	args = Tcl_Merge(argc-1, argv+1);
    } else {
	args = malloc(1);
	args[0] = '\0';
    }
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    sprintf(buf, "%d", argc-1);
    Tcl_SetVar(interp, "argc", buf, TCL_GLOBAL_ONLY);


    /*
     * Hunt around for the application library directory.  Look for:
     * 1) compiled in default
     * 2) command line override
     * 3) MXEDIT_LIB environment variable
     * 4) "."
     */
    if (libDir &&
	(stat(libDir, &statBuf) >= 0) && (S_ISDIR(statBuf.st_mode))) {
	Tcl_SetVar(interp, "mxLibrary", libDir, TCL_GLOBAL_ONLY);
    } else {
	libDir = NULL;
    }
    if (libDir == NULL) {
	libDir = getenv("MXEDIT_LIB");
	if (libDir &&
	    (stat(libDir, &statBuf) >= 0) && (S_ISDIR(statBuf.st_mode))) {
	    Tcl_SetVar(interp, "mxLibrary", libDir, TCL_GLOBAL_ONLY);
	} else {
	    static int warn = 0;
	    if (!warn) {
		fprintf(stderr, "envar MXEDIT_LIB \"%s\" not a valid directory\n",
		    libDir);
		fprintf(stderr, "Using \".\" for mxedit library directory\n");
		warn = 1;
	    }
	    libDir = ".";
	    Tcl_SetVar(interp, "mxLibrary", libDir, TCL_GLOBAL_ONLY);
	}
    }
    return args;
}

void
sig_setup(cookie)
    char *cookie;
{
    /*
     * Install signal handler for interupts (control-C).
     */
    oldhandler = signal(SIGINT, intrhandler);
    if ((int)oldhandler == -1) {
	perror("signal failed");
	exit(1);
    }
    oldhandler = signal(SIGALRM, intrhandler);
    if ((int)oldhandler == -1) {
	perror("signal failed");
	exit(1);
    }
#ifndef __hpux
    siginterrupt(SIGINT, 1);	/* ensure that wait() kicks out on interrupt */
    siginterrupt(SIGALRM, 1);	/* ensure that wait() kicks out on interrupt */
#endif

}

/*
 * Invoked upon interrupt (control-C)
 */
void
intrhandler(sig, code, scp, addr)
    int sig, code;
    struct sigcontext *scp;
    char *addr;
{
    longjmp(envX, 1);
}

void
terminate(cookie)
    char *cookie;
{
    printf("mxedit caught signal\n");
    Mx_Cleanup();
    exit(1);
}
