#! /bin/sh

#
# Copyright (c) 1994 Open Software Foundation, Inc.
# 
# Permission is hereby granted to use, copy, modify and freely distribute
# the software in this file and its documentation for any purpose without
# fee, provided that the above copyright notice appears in all copies, and
# that both the copyright notice and this permission notice appear in
# supporting documentation.  Further, provided that the name of Open
# Software Foundation, Inc. ("OSF") not be used in advertising or
# publicity pertaining to distribution of the software without prior
# written permission from OSF.  OSF makes no representations about the
# suitability of this software for any purpose.  It is provided "AS IS"
# without express or implied warranty.
#


# This is a wrapper for ot and ot_bugs.
# It checks the project (either on the command line or in an environment
# variable) and exec's the right image.

projParam=n
projDisable=n
disableAllPrj=n
projNot2ot=n
projName=""

if   [ "$disableAllPrj" = "y" ]; then
    echo "Access to all OT projects is temporary disabled"
    exit 0
fi

if [ $# -gt 0 ]; then
    for x in "$@"; do
	case "$x" in
	    -p*)	projParam=y;	;;
	    *)				;;
	esac
    done
fi

if [ $projParam = "n" ]; then
    if [ -n "$OT_PROJECT" ]; then
	case $OT_PROJECT in
	    hotline)		versEnv=3.0.1	;;
	    motif)		versEnv=3.0.1	;;
	    motifissue)		versEnv=3.0.1	;;
	    motiftest)		versEnv=3.0.1	;;
	    osf1)		versEnv=3.0.1	;;
	    osf1_maint)		versEnv=3.0.1	;;
	    osf1test)		versEnv=3.0.1	;;
	    osf1_perf)		versEnv=3.0.1	;;
	    osf1_qa)		versEnv=3.0.1	;;
	    osf1ad)		versEnv=3.0.1	;;
	    ot)			versEnv=3.0.1	;;
	    ode)		versEnv=3.0.1	;;
	    tpt)		versEnv=3.0.1	;;
	    tad)		versEnv=3.0.1	;;
	    vista)		versEnv=3.0.1	;;
	    calvin)		versEnv=3.0.1	;;
	    fsf)		versEnv=3.0.1	;;
	    ri-osc)		versEnv=3.0.1   ;;
	    dte)		versEnv=3.0.1	;;
	    ottest)		versEnv=3.0.1   ;;
	    v3test)		versEnv=3.0.1   ;;
	    testn)		versEnv=3.0.1   ;;
	    not)		projNot2ot=y	;;
#	    ot)			projDisable=y; projName=ot	;;
	    *)			;;
	esac
    fi
fi


if [ $# -gt 0 ]; then
    for x in "$@"; do
	case "$x" in
	    hotline|-photline)		versParam=3.0.1	;;
	    motif|-pmotif)		versParam=3.0.1 ;;
	    motifissue|-pmotifissue)	versParam=3.0.1	;;
	    motiftest|-pmotiftest)	versParam=3.0.1	;;
	    osf1|-posf1)		versParam=3.0.1	;;
	    osf1_maint|-posf1_maint)	versParam=3.0.1	;;
	    osf1test|-posf1test)	versParam=3.0.1	;;
	    osf1_perf|-posf1_perf)	versParam=3.0.1	;;
	    osf1_qa|-posf1_qa)		versParam=3.0.1	;;
	    osf1ad|-posf1ad)		versParam=3.0.1	;;
	    ot|-pot)			versParam=3.0.1	;;
	    ode|-pode)			versParam=3.0.1	;;
	    tpt|-ptpt)			versParam=3.0.1	;;
	    tad|-ptad)			versParam=3.0.1	;;
	    vista|-pvista)		versParam=3.0.1	;;
	    calvin|-pcalvin)		versParam=3.0.1	;;
	    fsf|-pfsf)			versParam=3.0.1	;;
	    ri-osc|-pri-osc)            versParam=3.0.1 ;;
	    dte|-pdte)			versParam=3.0.1	;;
	    ottest|-pottest)		versParam=3.0.1 ;;
	    v3test|-pv3test)		versParam=3.0.1	;;
	    testn|-ptestn)		versParam=3.0.1	;;
	    not|-pnot)			projNot2ot=y	;;
#	    ot|-pot)			projDisable=y; projName=ot	;;
	    *)				;;
	esac
    done
fi


if   [ "$projDisable" = "y" ]; then
    echo "Access to the $projName OT project is temporary disabled"
    exit 0
fi

if   [ "$projNot2ot" = "y" ]; then
    echo "Project 'not' had been renamed to 'ot'"
    exit 0
fi


if   [ "$versParam" = "3.0.1" ]; then
    exec $0.V301 "$@"
elif [ "$versEnv" = "3.0.1" ]; then 
    exec $0.V301 "$@"
else
    exec $0.V2 "$@"
fi

echo "exec failed"
