/* useMainWin.c
 *      - Tcl command for creating a new interpreter within same process
 *      - similar to tkMain.c 
 *        + without wish's prompt and tcl_RcFileName
 *        + calls Use_EntAppInit instead of Tcl_AppInit
 *      - returns name of new application for send-command
 *
 * Copyright (c) 1994 R"udiger Franke
 * All Rights Reserved.
 * 
 * Redistribution and use in any form, with or without modification, 
 * is permitted, provided that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in other form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *       This product includes software developed by R"udiger Franke.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdlib.h>
#include <string.h>

#include <tcl.h>
#include <tk.h>
#include <use.h>

/*
 * Command-line options:
 */

static char *fileName;

static Tk_ArgvInfo argTable[] = {
    {"-file", TK_ARGV_STRING, (char *) NULL, (char *) &fileName,
	"File from which to read commands"},
    {(char *) NULL, TK_ARGV_END, (char *) NULL, (char *) NULL,
	(char *) NULL}
};

/*---------------------------------------------------------------------------*/
int useMainWinCmd( ClientData dummy, Tcl_Interp *iinterp,
		  int argc, char *argv[])
{
    Tcl_Interp	*interp;
    Tk_Window	mainWindow = NULL;
    int		code;

    interp = Tcl_CreateInterp();

    /*
     * Parse command-line arguments for startup script.
     * If any, use it for applications default name.
     */

    fileName = NULL;

    if (Tk_ParseArgv(interp, (Tk_Window) NULL, &argc, argv, argTable, 0)
	    != TCL_OK) {
	goto error;
    }

    /*
     * Initialize the Tk application.
     */

    mainWindow = Use_InstallTk(interp, fileName, &argc, argv);
    if (mainWindow == NULL) {
	goto error;
    }

    /*
     * Invoke application specific initialization.
     */

    if (Use_EntInit(interp) != TCL_OK) {
	goto error;
    }

    /*
     * Invoke the script specified on the command line, if any.
     */

    if (fileName != NULL) {
	code = Tcl_VarEval(interp, "source ", fileName, (char *) NULL);
	if (code != TCL_OK) {
	    goto error;
	}
    }

    /*
     * Return name of new application for send
     */

    Tcl_SetResult(iinterp, Tk_Name(Tk_MainWindow(interp)), TCL_STATIC);
    return TCL_OK;

error:
    Tcl_SetResult(iinterp, interp->result, TCL_VOLATILE);
    if (mainWindow != NULL)
        Tk_DestroyWindow(mainWindow);
    Tcl_DeleteInterp(interp);
        
    return TCL_ERROR;
}
