#
# These procedures replace the Desktop procedures from the local
# tcl library.  They are required in distributed versions of Xgnuplot.
#
#
proc Desktop_Init { applic args } {
  global Desktop Sys Xgpl env

# process arguments
  set sd {} ; set command Xgnuplot ; set geometry {}
  for {set n 0} {$n < [llength $args]} {incr n} {
     set opt [lindex $args $n]
     switch -- $opt {
       {-command}    {incr n ; set command [lindex $args $n]}
       {-noX}        {set haveX 0}
       {-geometry}   {incr n ; set geometry [lindex $args $n]}
       {default}     {set sd $opt}
     }
  }

# X application parameters
  wm client . [exec hostname]
  if {[string length $geometry]} then {
      wm command . "$command -geometry $geometry"
  } else {
      wm command . "$command"
  }

# X bindings
  Entry_bindings
  Text_bindings

# overide paths for various elements (these must be "hard wired")
  set Desktop(src)         $sd
  set Desktop(lib)         $sd
  set Desktop(help)        $sd
  set Desktop(bitmaps)     $sd

# load application defaults
  if [info exists Xgpl(sysOptions)] then {
    if [file exists $Desktop(src)/$Xgpl(sysOptions)] then {
       source $Desktop(src)/$Xgpl(sysOptions)
    }
  }
  if [info exists Xgpl(userOptions)] then {
    if [file exists $Xgpl(userOptions) ] then {
       source $Xgpl(userOptions)
    }
  }



}

proc Desktop_Save { applic } {
   global fmdefaults
   global $applic
   upvar #0 $applic Applic
# open defaults file and save elements of Desktop array
   if {$applic == "Desktop"} then {
     set fid [open $Desktop(userOptions) w]
     foreach element [array names Desktop] {
       puts $fid "set Desktop($element) \{$Desktop($element)\}"
     }
     close $fid
   } else {
     if [info exists $applic] then {
       if [info exists Applic(userOptions)] then {
         set fid [open $Applic(userOptions) w]
         foreach element [array names Applic] {
            puts $fid "set $applic\($element\) \{$Applic($element)\}"
         }
         if {$applic == "Fm"} then {
           foreach element [array names fmdefaults] {
              puts $fid "set fmdefaults\($element\) \{$fmdefaults($element)\}"
           }
         }
         close $fid
       }
     }
   }
}
