#
# $Source: /home/catless/nlfm/Working/Zircon/Development/lib/RCS/errors.tcl,v $
# $Date: 1994/08/30 10:09:44 $
# $Revision: 1.15.1.6 $
#
proc irc401 {net prefix param pargs} {
    if [regexp -nocase {^zirconbot$} [set chan [lindex $pargs 1]]] {
	return
    }
    if ![string match {nil} [set this [Message :: find $chan]]] {
	$this addText @ERROR "*** $chan is not on IRC"
    } {
	$net display @ERROR "*** $param - $chan"
    }
}

proc irc404 {net prefix param pargs} {
    set this [Channel :: find [set chan [lindex $pargs 1]]]
    if ![string match {nil} $this] {
	$this addText @ERROR "*** $param"
    } {
	$net display @ERROR "*** Cannot send to channel ${chan}"
    }
}

proc irc406 {net prefix param pargs} {
    global whois
    set whois(err) [lindex $pargs 1]
}

proc resetNick {} {
    global nickname
    entrySet .ctl0.oFrm.nSFrm.nickname.entry "$nickname"
}

proc irc432 {net prefix param pargs} {
    resetNick
    mkInfoBox ERROR .@nicker {Nickname Error} "[lindex $pargs 1] : $param" \
      {OK {}}
}

proc irc433 {net prefix param pargs} {
    global startup
    resetNick
    if {$startup} {
	set kind SERROR
    } {
	set kind ERROR
    }
    mkInfoBox $kind .@nicker {Nickname Error} "[lindex $pargs 1] : $param" \
      {OK {}}
}

proc irc443 {net prefix param pargs} {
    mkInfoBox ERROR .@inver {Invite Error} \
      "[lindex $pargs 1] $param [lindex $pargs 2]" {OK {}}
}

proc irc471 {net prefix param pargs} {
    set chn [Channel :: find [set chan [lindex $pargs 1]]]
    mkDialog {} .@full {Channel Full} "Channel ${chan} is full!" \
      {} {OK {}} "{Try Again} {$chn sendJoin}"
}

proc irc473 {net prefix param pargs} {
    mkInfoBox ERROR .@invonly {Invitation Only} \
      "Channel [lindex $pargs 1] is invitation only!" {OK {}}
}

proc irc474 {net prefix param pargs} {
    mkInfoBox ERROR .@banned Banned \
      "You are banned from channel [lindex $pargs 1]!" {OK {}}
}

proc irc475 {net prefix param pargs} {
    set chn [Channel :: find [set chan [lindex $pargs 1]]]
    if [string match {} [$chn key]] {
	mkEntryBox .@key Key "Enter key for channel ${chan}:" \
	  {{Key {}}} "Join {$chn sendJoin}" {Cancel {}}
    } {
	mkDialog {} .@key "Bad Key" \
	  "Bad key for channel ${chan}!" [list [list Key [$chn key]]] \
	  "{Try Again} {$chn sendJoin}" {Cancel {}}
    }
}

