/* Kathi Fisler */
/* May 29, 1994 */
/* Code to support scheme style coding in Tcl */

#ifndef STDIO
#include <stdio.h>
#endif

#ifndef STDLIB
#include <stdlib.h>
#endif

#ifndef TCL
#include <tcl.h>
#endif

#ifndef TK
#include <tk.h>
#endif

#ifndef SCHEME
#include "scheme.h"
#endif

#ifndef STRING
#include <string.h>
#endif 

int Scheme_ReadFile(char *filename, Scheme_Env *env)
{
  Scheme_Object *obj, *ret;
  FILE *fp;

  fp = fopen (filename, "r");
  
  if (! fp)
    {
      scheme_signal_error ("error in scheme source file");
      return TCL_ERROR;
    }
  while ((obj = scheme_read (fp)) != scheme_eof)
    ret = scheme_eval (obj, env);

  fclose(fp);
  return TCL_OK;
}

int Scheme_SourceCmd(ClientData global_env, Tcl_Interp *interp,
		    int argc, char *argv[])
{
  return Scheme_ReadFile(argv[1], global_env);
}

char* Scheme_ResultStr(Scheme_Object *ret, Scheme_Env *env)
{
  static Scheme_Object *str_output_proc = (Scheme_Object *) NULL;
  
  Scheme_Object *obj;

  if (str_output_proc) {
    obj = scheme_apply (str_output_proc, scheme_make_pair (ret, scheme_null));
    return SCHEME_STR_VAL (obj);
  } else
    str_output_proc = scheme_lookup_global(scheme_intern_symbol ("sobj->tstr"),
					   env);
}

int Scheme_Cmd(ClientData global_env, Tcl_Interp *interp,
	      int argc, char *argv[])  {

  FILE *fp;
  Scheme_Object *obj, *ret;

  obj = (Scheme_Object *) string_scheme_read_caller ( argv[1] ) ;
  ret = scheme_eval (obj, global_env);
  interp->result = Scheme_ResultStr(ret, global_env); 
  return TCL_OK; 
}

int Scheme_Init(Tcl_Interp *interp)
{
  int code;
  Scheme_Env *env;

  env = scheme_basic_env();
  scheme_default_handler();
  GC_expand_hp(40);

  Tcl_CreateCommand(interp, "scheme", Scheme_Cmd, env, NULL);
  Tcl_CreateCommand(interp, "scheme_source", Scheme_SourceCmd, env, NULL);
  Scheme_ReadFile ("stcl.ss", env);
  Scheme_ResultStr(scheme_null, env);
} 
