#----------------------------------------------------------------------
# DIALOG BUTTON TEST
#----------------------------------------------------------------------
proc DialogButtonTest {} {
    set w .test_dialog
    if {[winfo exists $w] == 0} {
	toplevel $w
	frame $w.top -border 1 -relief raised
	message $w.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	    -relief flat -borderwidth 15 -width 350 \
	    -text [concat \
		   "This a standard Motif style dialog. It is divided "\
		   "into two areas: The control area on top and the action"\
		   "area at the bottom. The action area has a fixed height"\
		   "and by default it has four buttons: OK, Apply, Cancel"\
		   "and Help, but they may have different labels. You"\
		   "should also have plenty of padding space around the"\
		   "buttons. Now press the Help button to see another dialog"\
		   "or press the other buttons to close the dialog."]
	tixStdDlgButtons $w.btns \
	    -ok_cmd     "destroy $w" \
	    -apply_cmd  "destroy $w" \
	    -cancel_cmd "destroy $w" \
	    -help_cmd  "DialogButtonHelp"

	pack append $w.top \
	    $w.msg {top fill expand}
	pack append $w \
	    $w.top  {top fill expand}\
	    $w.btns {top fillx}
    }
}

proc DialogButtonHelp {} {
    set w .help_dialog
    if {[winfo exists $w] == 0} {
 	toplevel $w

	# top - the message
	#-------------------
	frame $w.top -border 1 -relief raised
	message $w.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	    -relief flat -borderwidth 15 -width 350 \
	    -text [concat \
		   "You have pressed the Help button."\
		   "The tixDlgButtons widget is more convinent to use than"\
		   "tixStdDlgButtons if the combination of buttons in your"\
		   "dialog is different than the standard dialog."]

 	# bottom - the buttons
	#---------------------
 	tixDlgButtons $w.btns
	$w.btns add -text Close -command "destroy $w"

	pack append $w.top \
	    $w.msg {top fill expand}
	pack append $w \
	    $w.top  {top fill expand}\
	    $w.btns {top fillx}

	pack append $w $w.btns {top fillx}
    }
}

#--------------------
# File Dialog
#--------------------
proc FileDialogTest {} {
    if [winfo exists .file_dialog] {
	wm deiconify .file_dialog 
    } else {
	tixMkFileDialog .file_dialog FileDialogCmd
    }
}

proc FileDialogCmd {file_name} {
    if {$file_name == ""} {
	MessageDialog [concat \
		       "Please select a file from the \"File\" list,"\
		       "or type it in the \"Selection\" entry manually"]
    } else {
	MessageDialog "The file you selected: \"$file_name\""
    }
}

proc MessageDialog {msg} {
    set w .message
    if {[winfo exists $w] == 0} {
	toplevel $w
	wm transient $w .tix_demo
	wm geometry $w +400+400

	# top - the message
	#-------------------
	frame $w.top -border 1 -relief raised
	message $w.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	    -relief flat -borderwidth 15 -width 350 \
	    -text $msg

	# bottom - the buttons
	#---------------------
	tixDlgButtons $w.btns
	$w.btns add -text Close -command "destroy $w"
	
	pack append $w.top \
	    $w.msg {top fill expand}
	pack append $w \
	    $w.top  {top fill expand}\
	    $w.btns {top fillx}
	
	pack append $w $w.btns {top fillx}
	
	tkwait visibility $w

	grab $w
    }
}

#--------------------
# ComboBox 
#--------------------
proc ComboBoxTest {} {
    set w .combo_test
    if {[winfo exists $w] != 0} {
	return
    }
    toplevel $w
    frame $w.top -border 1 -relief raised
    # The message
    #------------
    message $w.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	-relief flat -borderwidth 15 -width 280 \
	-text [concat \
	       "The Combo Box is a great space saver when you find your" \
		   "interface too cluttered. Also, for the naive users, a"\
		   "Combo Box also looks much less imposing that a List Box"]
    
    # Static, you can only choose from the fixed list
    #------------------------------------------------
    set labfm [tixLabelFrame $w.labfm1 -label " Static ComboBox "\
	       -border 10 ]
    tixComboBox $labfm.cbx -type static -command ComboBoxCommand -width 30
    $labfm.cbx appendhistory Janurary
    $labfm.cbx appendhistory Feburary
    $labfm.cbx appendhistory March
    $labfm.cbx appendhistory April
    $labfm.cbx appendhistory May
    $labfm.cbx appendhistory June
    $labfm.cbx appendhistory July
    $labfm.cbx appendhistory August
    $labfm.cbx appendhistory September
    $labfm.cbx appendhistory October
    $labfm.cbx appendhistory November
    $labfm.cbx appendhistory December
    $labfm.cbx appendhistory "That is about it"
    
    pack append $labfm\
	$labfm.cbx {fill expand}
    
    # Editable, you can type the selection in the entry
    #--------------------------------------------------
    set labfm [tixLabelFrame $w.labfm2 -label " Editable ComboBox "\
	       -border 10]
    tixComboBox $labfm.cbx -type editable -command ComboBoxCommand
    $labfm.cbx appendhistory "You can only type in the entry"
    $labfm.cbx appendhistory "And as a matter of fact"
    $labfm.cbx appendhistory "Your words will stay away"
    $labfm.cbx appendhistory "From the lovely list box"
    
    pack append $labfm\
	$labfm.cbx {fill expand}
    
    # History, your input in the entry is recorded and can be recalled
    #-----------------------------------------------------------------
    set labfm [tixLabelFrame $w.labfm3 -label " Histroy ComboBox "\
	       -border 10]
    tixComboBox $labfm.cbx -type history -command ComboBoxCommand
    $labfm.cbx appendhistory "You can edit tht entry plus"
    $labfm.cbx appendhistory "The list box will faithfully"
    $labfm.cbx appendhistory "Hold your words forever"
    
    pack append $labfm\
	$labfm.cbx {fill expand}
    
    # Other options
    #-----------------------------------------------------------------
    set labfm [tixLabelFrame $w.labfm4 -label " More Options "\
	       -border 10]
    tixComboBox $labfm.cbx -type history -command ComboBoxCommand \
	-height 100
    $labfm.cbx appendhistory "-height (this box = 100)"
    $labfm.cbx appendhistory "More will come in next release"
    $labfm.cbx appendhistory "Such as..."
    $labfm.cbx appendhistory "-sort   (sort the history)"
    $labfm.cbx appendhistory "-autocomplete"
    
    pack append $labfm\
	$labfm.cbx {fill expand}
    
    # The Buttons
    #-------------
    tixDlgButtons $w.btns
    $w.btns add -text "Close" -command  "destroy $w"
    
    # Pack everything
    #----------------
    pack append $w.top \
	$w.msg    {top}\
	$w.labfm1 {expand fill}\
	$w.labfm2 {expand fill}\
	$w.labfm3 {expand fill}\
	$w.labfm4 {expand fill}
    
    pack append $w \
	$w.top  {expand fill}\
	$w.btns {top fillx}
}

proc ComboBoxCommand {string} {
    puts "You selected \"$string\" in the combobox"
}


#--------------------
# LabelFrame
#--------------------
proc LabelFrameTest {} {
    set w .labelframe_test
    if {[winfo exists $w] == 0} {
	toplevel $w
	frame $w.top -border 1 -relief raised

	# The message
	#------------
	message $w.msg -font -*-times-*-r-*-*-14-*-*-*-*-*-*-*\
	    -relief flat -borderwidth 10 -width 180 \
	    -text [concat \
		   "The Label Frame can be used to logically group the"\
		   "related buttons logically together."]
	# the left frame
	#---------------
	set labfm1 [tixLabelFrame $w.lfm2 -label " Fonts " \
		    -border 10 -innerborder 5]
	radiobutton $labfm1.b1 -text "Courier"\
	    -variable xtest_color -relief flat
	radiobutton $labfm1.b2 -text "Helvetica"\
	    -variable xtest_color -relief flat
	radiobutton $labfm1.b3 -text "Lucida"\
	    -variable xtest_color -relief flat
	radiobutton $labfm1.b4 -text "Palatino"\
	    -variable xtest_color -relief flat

	pack append $labfm1 \
	    $labfm1.b1 {top fillx} \
	    $labfm1.b2 {top fillx} \
	    $labfm1.b3 {top fillx} \
	    $labfm1.b4 {top fillx}

	# the right frame
	#----------------
	set labfm2 [tixLabelFrame $w.lfm1 -label " Options " \
		    -border 10 -innerborder 5]
	checkbutton $labfm2.b1 -text "Bold"      -relief flat
	checkbutton $labfm2.b2 -text "Italic"    -relief flat
	checkbutton $labfm2.b3 -text "Underline" -relief flat
	pack append $labfm2 \
	    $labfm2.b1 {top fillx} \
	    $labfm2.b2 {top fillx} \
	    $labfm2.b3 {top fillx}

	pack append $w.top \
	    $w.msg  {top fillx}\
	    $w.lfm1 {left  expand filly} \
	    $w.lfm2 {right expand filly}

	tixDlgButtons $w.btns
	$w.btns add -text "Close" -command  "destroy $w"

	pack append $w \
	    $w.top {top fill expand }\
	    $w.btns {top fillx}
    }
}
