proc MkFileDialog1 {} {
    set w .file1

    if [winfo exists $w] {
	return
    }
    toplevel $w
    wm title $w "File Selection Box Infomation"

    frame $w.top -relief raised -border 1
    message $w.top.msg -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-* \
	-relief sunken -bd 1 -anchor n -padx 40 -width 400\
	-text {

File Selection Box

You can use the command "tixFileSelectBox" to create a TIX \
file-selection box, which is an extension of the standard Motif(TM)\
file-selection box. It keeps a history of the files recently selected by \
the user.

To look at the File Selection Dialog, press \
the "File >>" button. To end this dialog, press the "Close" \
button.
}
    tixDlgBtns $w.btns
    $w.btns add close -text "Close"   -width 7
    $w.btns add next  -text "File >>" -width 7

    pack $w.top.msg -expand yes -fill both -padx 10 -pady 10
    pack $w.top -expand yes -fill both 
    pack $w.btns -fill x

    $w.btns button close config -command "destroy $w"
    $w.btns button next  config -command "MkFileDialog2"
}

proc MkFileDialog2 {} {
    set w .file2
    if [winfo exists $w] {
	wm deiconify $w
    } else {
	tixMkFileDialog $w ShowFile
	wm title $w "Select File"
    }
    update; destroy .file1
}

proc ShowFile {filename} {
    set w .file3

    if [winfo exists $w] {
	destroy $w
    }
    toplevel $w
    wm title $w "Acknowledge"

    frame $w.top -relief raised -border 1
    message $w.top.msg -font -*-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-* \
	-relief sunken -bd 1 -anchor n -padx 40 -width 400\
	-text "You have selected the file 

\"$filename\""

    tixDlgBtns $w.btns
    $w.btns add close -text "Close"   -width 7

    pack $w.top.msg -expand yes -fill both -padx 10 -pady 10
    pack $w.top -expand yes -fill both 
    pack $w.btns -fill x

    $w.btns button close config -command "destroy $w"

    update
}
