proc tixControl {w args} {
    eval tixInt_CreateWidget $w tixCtl TixControl $args
    return $w
}

proc tixCtl::CreateClassRec {} {
    global tixCtl

    # OPTIONS
    set tixCtl(rootOptions)   {}
    set tixCtl(options)       {-background -bg -orient -value -step -ulimit
                               -llimit -repeatrate -initwait -command
			       -autorepeat
			       -disabledforeground -state
			       -font -background -bg -foreground -fg
			       -entrywidth -entrybg -entryfont}

    # DEFAULT VALUES
    set tixCtl(-autorepeat)   {-autorepeat autoRepeat AutoRepeat yes}
    set tixCtl(-background)   {-background background Background #ffe4c4}
    set tixCtl(-foreground)   {-foreground foreground Foreground black}
    set tixCtl(-disabledforeground) {\
	                       -disabledforeground\
	                       -disabledForeground\
	                       -DisabledForeground #606060}
    set tixCtl(-font)         {-font font Font \
	                     "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"}
    set tixCtl(-entrybg)      {-entrybg entryBg Background #ffe4c4}
    set tixCtl(-entryfont)    {-entryfont entryFont Font \
	                     "-*-helvetica-medium-r-normal-*-14-*-*-*-*-*-*-*"}
    set tixCtl(-orient)       {-orient orient Orient horizontal}
    set tixCtl(-value)        {-value value Value 0}
    set tixCtl(-step)         {-step step Step 1}
    set tixCtl(-state)        {-state state State normal}
    set tixCtl(-ulimit)       {-ulimit ulimit Ulimit {}}
    set tixCtl(-llimit)       {-llimit llimit Llimit {}}
    set tixCtl(-repeatrate)   {-repeatrate repeatRate RepeatRate 50}
    set tixCtl(-initwait)     {-initwait initWait InitWait 300}
    set tixCtl(-entrywidth)   {-entrywidth entryWidth EntryWidth 5}
    set tixCtl(-command)      {-command command Command {}}

    # ALIASES
    set tixCtl(-bg)           {= -background}
    set tixCtl(-fg)           {= -foreground}
    # METHODS
    set tixCtl(methods)       {get incr decr invoke}
}


proc tixCtl::ConstructWidget {w} {
    upvar #0 $w data

    set data(ent)  [entry $w.ent \
		    -width $data(-entrywidth) \
		    -fg $data(-foreground) \
		    -bg $data(-entrybg) \
		    -font $data(-entryfont)]
    set data(incr) [button $w.incr -text "+" \
		   -bg $data(-background)\
		   -fg $data(-foreground)\
		   -font $data(-font)]
    set data(decr) [button $w.decr -text "-" \
		   -bg $data(-background)\
		   -fg $data(-foreground)\
		   -font $data(-font)]

    if {$data(-orient) == "horizontal"} {
	pack $w.decr -side left  -anchor e
	pack $w.incr -side right -anchor w
	pack $w.ent -side left -expand yes -fill x -padx 1
    } else {
	pack $w.decr -side top  -anchor s -fill x
	pack $w.incr -side bottom -anchor n -fill x
	pack $w.ent -side bottom -expand yes -fill x -pady 1
    }

    $w.ent delete 0 end
    $w.ent insert 0 $data(-value)

    bind $w.incr <1> "tk_butDown %W; set [set w](flag) 1; tixCtl::IncrCmd $w"
    bind $w.decr <1> "tk_butDown %W; set [set w](flag) 1; tixCtl::DecrCmd $w"

    bind $w.incr <ButtonRelease-1> "tk_butUp %W; set [set w](flag) 0"
    bind $w.decr <ButtonRelease-1> "tk_butUp %W; set [set w](flag) 0"
    bind $w.incr <B1-Leave> "tk_butUp %W; set [set w](flag) 0"
    bind $w.decr <B1-Leave> "tk_butUp %W; set [set w](flag) 0"
    bind $w.incr <B1-Motion> "tk_butUp %W; set [set w](flag) 0"
    bind $w.decr <B1-Motion> "tk_butUp %W; set [set w](flag) 0"
    bind $w.ent  <Return> "tixCtl::invoke $w"
}

#----------------------------------------------------------------------
#                           CONFIG OPTIONS
#----------------------------------------------------------------------
proc tixCtl::config-background {w arg} {
    upvar #0 $w data

    $data(rootCmd) config -bg $arg
    $w.incr config -bg $arg
    $w.decr config -bg $arg
}

proc tixCtl::config-foreground {w arg} {
    upvar #0 $w data

    $w.ent  config -fg $arg
    $w.incr config -fg $arg
    $w.decr config -fg $arg
}

proc tixCtl::config-font {w arg} {
    upvar #0 $w data

    $w.incr config -font $arg
    $w.decr config -font $arg
}

proc tixCtl::config-state {w arg} {
    upvar #0 $w data

    if {$arg == "normal"} {
	$w.incr config -state $arg
	$w.decr config -state $arg
	$w.ent  config -state $arg -fg $data(-foreground)
    } else {
	$w.incr config -state $arg
	$w.decr config -state $arg
	$w.ent  config -state $arg -fg $data(-disabledforeground)
    }
}

proc tixCtl::config-entrybg {w arg} {
    upvar #0 $w data

    $w.ent config -bg $arg
}

proc tixCtl::config-entryfont {w arg} {
    upvar #0 $w data

    $w.ent config -font $arg
}
proc tixCtl::config-entrywidth {w arg} {
    upvar #0 $w data

    $data(ent) config -width $arg
}

proc tixCtl::config-orient {w arg} {
    upvar #0 $w data

    puts stderr "tixControl : config orient not implemented"
}

proc tixCtl::config-command {w arg} {
    # nothing needed here
}

proc tixCtl::config-value {w arg} {
    upvar #0 $w data

    if {$data(-llimit) != {} && $arg < $data(-llimit)} {
	puts error
	return
    }
    if {$data(-ulimit) != {} && $arg > $data(-llimit)} {
	puts error
	return
    }
    $data(ent) delete 0 end
    $data(ent) insert 0 $arg
}

proc tixCtl::config-ulimit {w arg} {

}

proc tixCtl::config-llimit {w arg} {

}

proc tixCtl::config-step {w arg} {
}

proc tixCtl::config-autorepeat {w arg} {
}
#----------------------------------------------------------------------
#                         User Commands
#----------------------------------------------------------------------
proc tixCtl::get {w} {
    upvar #0 $w data

    return $data(-value)
}

proc tixCtl::incr {w} {

}

proc tixCtl::decr {w} {
}

proc tixCtl::invoke {w} {
    upvar #0 $w data

    if {[catch {$data(ent) index sel.first}] == 0} {
	# OWNS SELECTION --> TURN IT OFF
	$data(ent) select from end
	$data(ent) select to   end
    }
    set oldvalue $data(-value)
    set data(-value) [$data(ent) get]
    if [catch {
	if {$data(-ulimit) != {} && $data(-value) > $data(-ulimit)} {
	    set data(-value) $data(-ulimit)
	    $data(ent) delete 0 end
	    $data(ent) insert 0 $data(-value)
	}
 	if {$data(-llimit) != {} && $data(-value) < $data(-llimit)} {
	    set data(-value) $data(-llimit)
	    $data(ent) delete 0 end
	    $data(ent) insert 0 $data(-value)
	}
    }] {
	set data(-value) $oldvalue
	$data(ent) delete 0 end
	$data(ent) insert 0 $data(-value)
    }

    if {$data(-command) != {}} {
	eval $data(-command) $data(-value)
    }
}

#----------------------------------------------------------------------
#                       Internal Commands
#----------------------------------------------------------------------
proc tixCtl::IncrCmd {w} {
    upvar #0 $w data

    if {$data(flag) != "0"} {
	set data(-value) [expr "$data(-value) + $data(-step)"]
	if {$data(-ulimit) != {} && $data(-value) > $data(-ulimit)} {
	    set data(-value) $data(-ulimit)
	}
	$data(ent) delete 0 end
	$data(ent) insert 0 $data(-value)
	if {$data(-command) != {}} {
	    eval $data(-command) $data(-value)
	}

	if {$data(-autorepeat) == "yes"} {
	    if {$data(flag) == "1"} {
		after $data(-initwait) tixCtl::IncrCmd $w
		set data(flag) 2
	    } else {
		after $data(-repeatrate) tixCtl::IncrCmd $w
	    }
	}
    }
}

proc tixCtl::DecrCmd {w} {
    upvar #0 $w data

    if {$data(flag) != "0"} {
	set data(-value) [expr "$data(-value) - $data(-step)"]
	if {$data(-llimit) != {} && $data(-value) < $data(-llimit)} {
	    set data(-value) $data(-llimit)
	}
	$data(ent) delete 0 end
	$data(ent) insert 0 $data(-value)

	if {$data(-command) != {}} {
	    eval $data(-command) $data(-value)
	}
	if {$data(-autorepeat) == "yes"} {
	    if {$data(flag) == "1"} {
		after $data(-initwait) tixCtl::DecrCmd $w
		set data(flag) 2
	    } else {
		after $data(-repeatrate) tixCtl::DecrCmd $w
	    }
	}
    }
}
