global auto_path
lappend auto_path .
lappend auto_path ../library
source ../library/tkIconPaneCmd.tcl

proc demoEval {command} {
  .t.t delete 1.0 end
  .t.t insert end "[string trim $command]\n"
  .t.t insert end "--------------------------->>>>>>\n"
  .t.t insert end [string trim [eval $command]]
}

proc toolbarDropCommand {sourcePathName sourceIconId targetPathName} {
  puts stdout "$sourcePathName $sourceIconId $targetPathName"
}

proc dropCommand {sourcePathName sourceIconId targetPathName targetIconId} {
  if {"$targetIconId" != ""} {
    puts stdout "I received an icon from: $sourcePathName $sourceIconId to $targetPathName $targetIconId"
  } {
    if {"$sourcePathName" != "$targetPathName"} {
      puts stdout "I received an icon from: $sourcePathName $sourceIconId to $targetPathName $targetIconId"
    } {
      set tmpPos [tkiconpane_dropPosition $sourcePathName]
      $sourcePathName iconconfig $sourceIconId -x [lindex $tmpPos 0] -y [lindex $tmpPos 1]
      catch "$sourcePathName layout edges" res
    }
  }
}

proc DAGLayout {pathName args} {
  $pathName layout isi -graphorder 0 -iconspaceh 10 -iconspacev 10 -keeprandompositions 1 -xoffset 30 -yoffset 70
}

proc iconSort {canvasPath idList} {
  set iconList ""
  set nameCounter 0
  foreach counter $idList {
    set tmpName [lindex [$canvasPath itemconfig $counter -name] 4]
    if {![catch "set tmpNameList($tmpName)"]} {
      set tmpName [lindex [$canvasPath itemconfig $counter -text] 4]
      if {![catch "set tmpNameList($tmpName)"]} {
        while {![catch "set tmpNameList($tmpName$nameCounter)"]} {
          incr nameCounter
        }
        set tmpName $tmpName$nameCounter
      }
    }
    set tmpNameList($tmpName) $counter
  }
  if {[info exists tmpNameList]} {
    foreach counter [lsort [array names tmpNameList]] {
      lappend iconList [set tmpNameList($counter)]
    }
  }
  return $iconList
}

menu .root
.root add command -label {Relayout} -command {
  set w [tkiconpane_info tkiconpane]
  $w status "Relayouting..."
  $w layout
  $w status "Relayouting...done"}
.root add command -label {Fit} -command {
  [tkiconpane_info tkiconpane] config -scale -1}
.root add command -label {Scale 1} -command {
  [tkiconpane_info tkiconpane] config -scale 0.3}
.root add command -label {Scale 2} -command {
  [tkiconpane_info tkiconpane] config -scale 0.6}
.root add command -label {Scale 3} -command {
  [tkiconpane_info tkiconpane] config -scale 1.0}
.root add command -label {Scale 4} -command {
  [tkiconpane_info tkiconpane] config -scale 2.2}
.root add command -label {Scale 5} -command {
  [tkiconpane_info tkiconpane] config -scale 3.3}

menu .edge
.edge add command -label {Edge handling}

wm maxsize . 1000 1000

tkiconpane .v -toplevel 0 \
  -layoutupdate 1\
  -dragdrop 1 \
  -dropcommand {dropCommand} \
  -layout 0 \
  -menubar standard \
  -menupath {../library/viewMenus} \
  -name standard \
  -statusvariable STATUS0 \
  -toolbartop standard \
  -toolbarbottom standard \
  -toolbarleft standard \
  -toolbarright standard
wm geometry . 300x300

tkiconpane .u -toplevel 1 \
  -dragdrop 1 \
  -dropcommand {dropCommand} \
  -layout 0 \
  -layoutcommand {random} \
  -menu1 standard \
  -menubar standard \
  -menupath {../library/viewMenus} \
  -name VIEW8 \
  -statusvariable STATUS8
wm geometry .u 300x300

tkiconpane .w -toplevel 1 \
  -dragdrop 1 \
  -dropcommand {dropCommand} \
  -edgemenupath {../library/menus} \
  -iconmenupath {../library/menus} \
  -iconpixmappath {../library/icons} \
  -iconstatuspath {../library/status} \
  -layout 0 \
  -layoutcommand {matrix -computeiconsize 1 -iconspaceh 10 -iconspacev 10 -xoffset 30 -yoffset 70} \
  -menu1 .root \
  -menu2 .root \
  -menu3 .root \
  -menubar standard \
  -menupath {../library/viewMenus} \
  -name {VIEW1} \
  -placing 1 \
  -sortcommand iconSort \
  -statusvariable STATUS1 \
  -title {VIEW1}
wm geometry .w 300x300

tkiconpane .x -toplevel 1 \
  -computeiconsize 0 \
  -dragdrop 1 \
  -dropcommand {dropCommand} \
  -iconheight 50 \
  -iconspaceh 5 \
  -iconspacev 5 \
  -iconwidth 50 \
  -layout 0 \
  -menubar standard \
  -menupath {../library/viewMenus} \
  -name {VIEW2} \
  -placing 0 \
  -statusafter 2000 \
  -statusvariable STATUS2 \
  -title {VIEW2}
wm geometry .x 300x300

tkiconpane .y -toplevel 1 \
  -dragdrop 1 \
  -dropcommand {dropCommand} \
  -edgemenupath {../library/menus} \
  -iconmenupath {../library/menus} \
  -iconstatuspath {../library/status} \
  -layout 0 \
  -layoutcommand {isi} \
  -menu1 standard \
  -menu2 .root \
  -menubar standard \
  -menupath {../library/viewMenus} \
  -name {VIEW3} \
  -placing 1 \
  -statusafter 2000 \
  -statusvariable STATUS3 \
  -title {VIEW3}
wm geometry .y 300x300

foreach counter [glob * -nocomplain] {
  .u iconcreate $counter \
    -borderwidth 1 \
    -command "puts stdout " \
    -dropcommand dropCommand \
    -status none \
    -text $counter \
    -type c
}
.u layout

foreach counter [glob * -nocomplain] {
  .w iconcreate $counter \
    -borderwidth 1 \
    -command "puts stdout " \
    -dropcommand dropCommand \
    -menu1 [string range [file extension $counter] 1 end] \
    -status none \
    -text $counter \
    -type standard
}
.w layout

foreach counter [glob * -nocomplain] {
  .x iconcreate $counter \
    -borderwidth 1 \
    -command "puts stdout " \
    -dropcommand dropCommand \
    -status none \
    -text $counter \
    -type [string range [file extension $counter] 1 end]
}
.x layout

foreach counter [exec ls /usr/local/bin] {
  .v iconcreate $counter \
    -borderwidth 2 \
    -command "puts stdout " \
    -dropcommand dropCommand \
    -relief raised \
    -status none \
    -text $counter \
    -type [string range [file extension $counter] 1 end]
}
.v layout

set oldCounter ""
foreach counter {{node1[1.2]} node2 node3 node4 node5 longnode6 longnode7 verylongnode8 node9 node10 node11 node13 node14 node15 node16} {
  set item [.y iconcreate $counter \
    -command "puts stdout " \
    -menu1 c \
    -status none \
    -name $counter \
    -text $counter]
}
foreach counter {{3 4} {3 7} {8 5} {3 10} {4 6} {10 8} {6 13} {4 7} {10 11} {9 10} {3 9} {3 12}} {
  .y edgecreate mygraph [list [lindex $counter 0] [lindex $counter 1] 0 -fill red -arrow last -label {sabber[1.3]} -menu1 standard -menu2 .edge -name sabber$counter]
}

foreach counter {{14 15} {14 16} {16 17} {14 10}} {
  .y edgecreate mygraph2 [list [lindex $counter 0] [lindex $counter 1] 0 -fill blue -arrow last -label {sabber[1.3]} -menu1 standard -menu2 .edge -name sabber$counter]
}

.y layout
.w config -layoutcommand {nolayout}

pack append . .v {top fill expand}

toplevel .t

wm maxsize .t 1000 1000

frame .t.f -borderwidth 2 -relief raised

frame .t.f.f1 -borderwidth 2 -relief flat

frame .t.f.f2 -borderwidth 2 -relief flat

frame .t.f.f3 -borderwidth 2 -relief flat

frame .t.f.f4 -borderwidth 2 -relief flat

frame .t.f.f5 -borderwidth 2 -relief flat

button .t.f.f1.b1 \
  -text {All icon ids in VIEW3} \
  -command {demoEval {.y iconinfo ids}}

button .t.f.f1.b2 \
  -text {All icon names in VIEW3} \
  -command {demoEval {.y iconinfo names}}

button .t.f.f1.b3 \
  -text {All graphs in VIEW3} \
  -command {demoEval {.y edgeinfo graphs}}

button .t.f.f1.b4 \
  -text {All graph edge ids in VIEW3} \
  -command {demoEval {.y edgeinfo ids mygraph}}

button .t.f.f1.b5 \
  -text {All graph edge names in VIEW3} \
  -command {demoEval {.y edgeinfo names mygraph}}

button .t.f.f1.b6 \
  -text {All graph connection ids in VIEW3} \
  -command {demoEval {.y edgeinfo fromtoids mygraph}}

button .t.f.f1.b7 \
  -text {All graph connection names in VIEW3} \
  -command {demoEval {.y edgeinfo fromtonames mygraph}}

button .t.f.f2.b1 \
  -text {Current pane} \
  -command {demoEval {tkiconpane_info tkiconpane}}

button .t.f.f2.b2 \
  -text {Current pane name} \
  -command {demoEval {tkiconpane_info tkiconpanename}}

button .t.f.f2.b3 \
  -text {Current pane canvas} \
  -command {demoEval {tkiconpane_info canvaspath}}

button .t.f.f2.b4 \
  -text {Current pane current icon name} \
  -command {demoEval {tkiconpane_info iconinfo name}}

button .t.f.f2.b5 \
  -text {Current pane selected icon ids} \
  -command {demoEval {tkiconpane_info iconinfo selectedids}}

button .t.f.f2.b6 \
  -text {Current pane selected icon names} \
  -command {demoEval {tkiconpane_info iconinfo selectednames}}

button .t.f.f2.b7 \
  -text {Current pane current icon state} \
  -command {demoEval {tkiconpane_info iconinfo state}}

button .t.f.f2.b8 \
  -text {Current pane current icon status} \
  -command {demoEval {tkiconpane_info iconinfo status}}

button .t.f.f2.b9 \
  -text {Current pane current icon tags} \
  -command {demoEval {tkiconpane_info iconinfo tags}}

button .t.f.f2.b10 \
  -text {Current edge current edge id} \
  -command {demoEval {tkiconpane_info edgeinfo id mygraph}}

button .t.f.f2.b11 \
  -text {Current edge current edge name} \
  -command {demoEval {tkiconpane_info edgeinfo name mygraph}}

button .t.f.f2.b12 \
  -text {Current edge current edge fromto id} \
  -command {demoEval {tkiconpane_info edgeinfo fromtoid mygraph}}

button .t.f.f2.b13 \
  -text {Current edge current edge fromto name} \
  -command {demoEval {tkiconpane_info edgeinfo fromtoname mygraph}}

button .t.f.f3.b1 \
  -text {Changed} \
  -command {demoEval {.y config -changed 1}}

button .t.f.f3.b2 \
  -text {Status} \
  -command {demoEval {.y status "new status"}}

button .t.f.f3.b3 \
  -text {Layout} \
  -command {demoEval {.y layout}}

button .t.f.f3.b4 \
  -text {Configure all} \
  -command {demoEval {.y config}}

button .t.f.f3.b5 \
  -text {Configure get} \
  -command {demoEval {.y config -background}}

button .t.f.f3.b6 \
  -text {Configure set} \
  -command {demoEval {.y config -activebackground white
.y config -activeforeground green
.y config -background blue
.y config -cursor arrow
.y config -font *times*
.y config -foreground red
.y config -padx 10
.y config -pady 5
.y config -changed 1
.y config -computeiconsize 0
.y config -iconheight 50
.y config -iconwidth 50
.y config -iconspaceh 10
.y config -iconspacev 10
.y config -scrollactiveforeground magenta
.y config -scrollside right
.y config -statusafter 10
.y config -title view3}}

button .t.f.f4.b1 \
  -text {Create icon} \
  -command {demoEval {.y iconcreate sabber -text sabber -bitmap @../demo.TkIcon/icon2.xpm -status status2}
.y layout}

button .t.f.f4.b2 \
  -text {Create edge} \
  -command {demoEval {.y edgecreate mygraph [list [.y iconinfo id sabber] [.y iconinfo id node5] 2]}}

button .t.f.f4.b3 \
  -text {Edge longnode6-node3} \
  -command {demoEval {.y edgeinfo id mygraph [.y iconinfo id node2] [.y iconinfo id node4]}}

button .t.f.f4.b4 \
  -text {Configure graph} \
  -command {demoEval {.y edgeconf mygraph -fill blue}}

button .t.f.f4.b5 \
  -text {Configure edge all} \
  -command {demoEval {.y edgeconf mygraph [.y edgeinfo id mygraph [.y iconinfo id node2] [.y iconinfo id node4]]}}

button .t.f.f4.b6 \
  -text {Configure edge get} \
  -command {demoEval {.y edgeconf mygraph [.y edgeinfo id mygraph [.y iconinfo id node2] [.y iconinfo id node4]] -fill}}

button .t.f.f4.b7 \
  -text {Configure edge set} \
  -command {demoEval {.y edgeconf mygraph [.y edgeinfo id mygraph [.y iconinfo id node2] [.y iconinfo id node4]] -fill green}}

button .t.f.f4.b8 \
  -text {Configure icon status} \
  -command {demoEval {.y iconconf [.y iconinfo id sabber] -status compressed}}

button .t.f.f4.b9 \
  -text {Delete icon} \
  -command {demoEval {.y icondelete [.y iconinfo id node10]}}

button .t.f.f4.b10 \
  -text {Delete edge} \
  -command {demoEval {.y edgedelete mygraph [.y iconinfo id verylongnode8] [.y iconinfo id node9]}}

button .t.f.f4.b11 \
  -text {Delete graph} \
  -command {demoEval {.y edgedelete mygraph}}

button .t.f.f4.b12 \
  -text {Set icon state} \
  -command {demoEval {.y iconinfo statedeselect}}

button .t.f.f4.b13 \
  -text {Toggle icon state} \
  -command {demoEval {.y iconinfo statetoggle [.y iconinfo id longnode7]}}

button .t.f.f5.b1 \
  -text {Set icon bitmap} \
  -command {demoEval {.y iconconfig [.y iconinfo id node2] -bitmap @../demo.TkIcon/icon2.xpm}
.y layout}

button .t.f.f5.b2 \
  -text {Layout mygraph} \
  -command {demoEval {.y.xfcanvas.xfcanvas.xfcanvas layout isi -graphname mygraph}}

button .t.f.f5.b3 \
  -text {Layout mygraph2} \
  -command {demoEval {.y.xfcanvas.xfcanvas.xfcanvas layout isi -graphname mygraph2}}

button .t.f.f5.b4 \
  -text {Create broken edge} \
  -command {
set coords [.y.xfcanvas.xfcanvas.xfcanvas coords [.y edgeinfo id mygraph [.y iconinfo id node2] [.y iconinfo id node4]]]
set x1 [lindex $coords 0]
set x2 [expr [lindex $coords 0]+40]
set x3 [lindex $coords 2]
set y1 [lindex $coords 1]
set y2 [expr [lindex $coords 1]+40]
set y3 [lindex $coords 3]
demoEval ".y.xfcanvas.xfcanvas.xfcanvas coords \[.y edgeinfo id mygraph \[.y iconinfo id node2\] \[.y iconinfo id node4\]\] $x1 $y1 $x2 $y2 $x3 $y3"}

button .t.f.f5.b5 \
  -text {Destroy .v} \
  -command {destroy .v}

button .t.f.f5.b6 \
  -text {Destroy all} \
  -command {destroy .u; destroy .y; destroy .x; destroy .w}

button .t.f.f5.b7 \
  -text {X activity} \
  -command {puts stdout [winfo width .]; puts stdout [info commands]}

text .t.t -borderwidth 2 -relief raised -height 10

pack append .t.f.f1 \
            .t.f.f1.b1 {top fill} \
            .t.f.f1.b2 {top fill} \
            .t.f.f1.b3 {top fill} \
            .t.f.f1.b4 {top fill} \
            .t.f.f1.b5 {top fill} \
            .t.f.f1.b6 {top fill} \
            .t.f.f1.b7 {top fill}

pack append .t.f.f2 \
            .t.f.f2.b1 {top fill} \
            .t.f.f2.b2 {top fill} \
            .t.f.f2.b3 {top fill} \
            .t.f.f2.b4 {top fill} \
            .t.f.f2.b5 {top fill} \
            .t.f.f2.b6 {top fill} \
            .t.f.f2.b7 {top fill} \
            .t.f.f2.b8 {top fill} \
            .t.f.f2.b9 {top fill} \
            .t.f.f2.b10 {top fill} \
            .t.f.f2.b11 {top fill} \
            .t.f.f2.b12 {top fill} \
            .t.f.f2.b13 {top fill}

pack append .t.f.f3 \
            .t.f.f3.b1 {top fill} \
            .t.f.f3.b2 {top fill} \
            .t.f.f3.b3 {top fill} \
            .t.f.f3.b4 {top fill} \
            .t.f.f3.b5 {top fill} \
            .t.f.f3.b6 {top fill}

pack append .t.f.f4 \
            .t.f.f4.b1 {top fill} \
            .t.f.f4.b2 {top fill} \
            .t.f.f4.b3 {top fill} \
            .t.f.f4.b4 {top fill} \
            .t.f.f4.b5 {top fill} \
            .t.f.f4.b6 {top fill} \
            .t.f.f4.b7 {top fill} \
            .t.f.f4.b8 {top fill} \
            .t.f.f4.b9 {top fill} \
            .t.f.f4.b10 {top fill} \
            .t.f.f4.b11 {top fill} \
            .t.f.f4.b12 {top fill} \
            .t.f.f4.b13 {top fill}

pack append .t.f.f5 \
            .t.f.f5.b1 {top fill} \
            .t.f.f5.b2 {top fill} \
            .t.f.f5.b3 {top fill} \
            .t.f.f5.b4 {top fill} \
            .t.f.f5.b5 {top fill} \
            .t.f.f5.b6 {top fill} \
            .t.f.f5.b7 {top fill}
 
pack append .t.f \
            .t.f.f1 {left fill expand} \
            .t.f.f2 {left fill expand} \
            .t.f.f3 {left fill expand} \
            .t.f.f4 {left fill expand} \
            .t.f.f5 {left fill expand}

pack append .t \
            .t.f {top fill} \
            .t.t {top fill}

# eof
